#ifndef WPIPE_WBLOCK_HH
#define WPIPE_WBLOCK_HH

// WBLOCK Omega Pipeline function to analyze a single block of data
//
// usage: wblock(blockStartTime, tiling, eventTime, 
//               parameterFile, frameCacheFile, outputFiles, debugLevel);
//
//   blockStartTime        gps block start time
//   tiling                q tiling structure
//   eventTime             eventTime to focus search around ([])
//   parameters            parameter structure
//   frameCache            frame cache structure
//   outputFiles           structure of output file names
//   debugLevel            verboseness level of debug output
//
// If given output arguments, WBLOCK will output the following fields:
//
//   triggersThresholded   thresholded triggers
//   triggersDownselected  downselected triggers
//   triggersVetoed        vetoed triggers
//   triggersClustered     clustered triggers
//   triggersCoincident    coincident triggers
//   event                 event information
//   skymap                bayesian skymap
//   transforms            transform structure
//
// The specified debugLevel controls the amount of detail in the output log.
// A debugLevel of unity is assumed by default.
//
// See also WPARAMETERS, WTILE, WREADDATA, WRESAMPLE, WCONDITION, WTRANSFORM,
// WTHRESHOLD, WSELECT, and WWRITEEVENTS.

// Authors:
// Jameson Rollins <jrollins@phys.columbia.edu>
// Antony Searle <antony.searle@anu.edu.au>
// Shourov K. Chatterji <shourov@ligo.caltech.edu>
// Leo C. Stein <lstein@ligo.mit.edu>

#include "wtypes.hh"
#include "wresample.hh"

class Time;

namespace wpipe {

  class wtile;
  struct wparameters;
  class wframecache;
  class woutput;

  class wblock {
  public:
    wblock(void) {}
    void process(const Time& blockStartTime, const wtile&  tiling, 
		 const Time& eventTime, const wparameters& parameters, 
		 const wframecache& frameCache, woutput& outputFiles, 
		 int debugLevel, str_vect& channelNames);
  private:
    resampler resample;
  };
} // namespace wpipe

#endif // !defined(WPIPE_WBLOCK_HH)
