/***************************************************************************
    File        : WindowFilter Design.h
    Description : Creates a filter based on the Windowing method
 ---------------------------------------------------------------------------
    Begin       : Thu Dec 11 2003
    Author(s)   : Roberto Grosso
 ***************************************************************************/

#ifndef __WINDOW_FILTER_DESIGN_H
#define __WINDOW_FILTER_DESIGN_H

// Libs
#include <vector>

// Project files
#include "Utilities.h"
#include "Types.h"
#include "Fourier.h"
#include "Window.h"


namespace gwd {


  class WindowFilterDesign {
  public:
    WindowFilterDesign() {}
    ~WindowFilterDesign() {}

    // Methods
    void ComputeFilter(const unsigned int order,const std::vector<Complex>& freq,Vector& flt);
    void ComputeFilter(const WindowType wt,const unsigned int order,const std::vector<Complex>& freq,Vector& flt);
    void ComputeFilter(const Vector& window,const std::vector<Complex>& freq,Vector& flt);
  private:

  };


} // namespace gwd
#endif // __WINDOW_FILTER_DESIGN_H

