/***************************************************************************
    File        : RunningMedian.h
    Description : Computes the running median of a time series
 ---------------------------------------------------------------------------
    Begin       : Fri Jan 2 2004
    Author(s)   : Roberto Grosso
 ***************************************************************************/

#ifndef __RUNNING_MEDIAN_
#define __RUNNING_MEDIAN_

/*! \file RunningMedian.h
 *  Computes the running median.
 */

// Libs
#include <algorithm>
#include <cassert>
#include <iostream>
#include <list>
#include <set>
#include <vector>

// Project files
#include "Types.h"
#include "Utilities.h"
#include "Numeric.h"

namespace gwd {

  //! Computes the running median.
  class RunningMedian {
  public:
    /** Default Constructor, initialize filter size to zero */
    RunningMedian() : mFilterSize(0) {}

    /** Desctructor */
    ~RunningMedian() {}

    /**
    ** Computes the running median of a time series.
    ** The algorithm uses the set class of the STL.
    ** @param filtersize size of the median filter.
    ** @param in input time series.
    ** @param out output filtered time series.
    **/
    bool ComputeMedians(const int filtersize,const Vector& in,Vector& out );

    /**
    ** Queries the median filter size.
    **/
    Vector::size_type FilterSize() { return mFilterSize; }

  private:
    Vector::size_type mFilterSize;
  };



} // namespace

#endif // __RUNNING_MEDIAN_


