/***************************************************************************
    File        : Multirate.h
    Description : Decimate, interpolate and resample a signal
 ---------------------------------------------------------------------------
    Begin       : Tue Aug 30 2005
    Author(s)   : Roberto Grosso
 ***************************************************************************/

#ifndef __BUTTERWORTHFILTER_H
#define __BUTTERWORTHFILTER_H

/*!
 * \file ButterworthFilter.h
 * Decimate, interpolate and resample a signal.
 * \brief Decimate, interpolate and resample a signal.
 */


// Libs
#include <cstdlib>
#include <cmath>
#include <complex>
#include <iostream>
#include <limits>
#include <numeric>
#include <vector>


// Project
#include "Types.h"
#include "Singleton.h"
#include "Numeric.h"
#include "FIRFilter.h"

namespace gwd {

  //! Decimate, interpolate and resample a signal.
  class Multirate {
  public:
    /** Default contructor */
    Multirate()  {}

    /** Destructor */
    virtual ~Multirate() {}

    // Methods
    bool Decimate(const int factor,Vector& h,Vector& in,Vector& out);
    //bool Interpolate(const int factor,Vector& h,Vector& in,Vector& out);
    //bool Resample(const int interp,const int decima,Vector& h,Vector&in,Vector& out);
  private:
      
  };

  
} // namespace gwd
#endif // __BUTTERWORTHFILTER_H


