/***************************************************************************
    File        : FrequencyBand.h
    Description : The noise floor of a frequency band
 ---------------------------------------------------------------------------
    Begin       : Thu May 11 2006
    Author(s)   : Roberto Grosso
 ***************************************************************************/

#ifndef __FREQUENCYBAND_H
#define __FREQUENCYBAND_H


/**  \file FeequencyBand.h
 **  The structure FrequencyBand contains the time series data and 
 **  a low-pass, band-pass and a high-pass filter, which are necessary
 **  for obtaining the frequency band.
 **
 **  \author Roberto Grosso; Brownsville, Texas
 **  \version 1.1; Last modified April 14, 2006
 **  \date Thu May 11 2006
 **/

// Libs
#include <string>
#include <list>

// Project files
#include "TSeries.hh"

// Wave library
#include "Types.h"

namespace gwd {

  const int LOW_PASS   = 1;
  const int BAND_PASS  = 2;
  const int HIGH_PASS  = 3;

  /** \struct FrequencyBand
   ** In order to obtain a base-banded frequency band, first a band-pass filter and then
   ** a low-pass filter are applied. Furhtermore, the frequency band is characterized by
   ** the sampling rate and a decimation factor. The decimation factor determine the 
   ** down-sampling ratio with respect to the 4kHz time series obtained form the 
   ** detector channel.
   **/
  struct FrequencyBand {
    //! Constructor
    FrequencyBand( ) { }
    //! Destructor
    virtual ~FrequencyBand() { }

    //! Low frequency of frequency band.
    double mLowFreq;
    //! High frequency of frequency band.
    double  mHighFreq;
    //! Sample rate of time series for this frequency.
    double mSampleRate;
    //! Decimation factor to reduce sample rate from detector signal.
    int mDecimate;
    //! The mean value of the normal distribution obtained with monte-carlo.
    double mMean;
    //! The standard deviation of the normal distribution obtained with monte-carlo.
    double mStdDev;
    
    //! Noise floor for the low frequency band.
    Vector mNoiseFloor;
    //! The noise floor data for the dmt.
    TSeries mTS;
    //! Data for the 12 hs plot.
    std::list<double> m12hsPlot;
    //! The noise floor data for the 12hs plot.
    TSeries mTS12hs;
    
    //! The low-pass filter.
    Vector mLowPassFlt;
    //! The band-pass filter.
    Vector mBandPassFlt;
    //! The high-pass filter.
    Vector mHighPassFlt;
    
    //! Determine if it is low-pass, band-pass or high-pass band.
    int type;
  };
} // namespace gwd
#endif     //  __FREQUENCYBAND_H
