#include "Sine.hh"
#include "Time.hh"
#include "constant.hh"
#include <math.h>

//-------------------------------------  Sine Constructor. 
Sine::Sine(double Freq, double ampl, double phi0, 
           const Interval& dT, const Time& t0)
  : mT0(t0), mTc(t0), mPhic(phi0), mAmpl(ampl)
{
    mOmega = twopi * Freq;
    mTl     = t0 + dT;
}

//-------------------------------------  Frequency domain template bin.
fComplex 
Sine::Fspace(double Freq, double dF) const {
    fComplex r(-pow((Freq-mOmega/twopi)/dF, 2), mPhic);
    return exp(r);
}

//-------------------------------------  Time domain template bin.
double 
Sine::Tspace(const Time& t0) const {
    return Ampl(t0)*sin(phi(t0));
}

//-------------------------------------  Get the t0.
Time 
Sine::getT0(void) const {
    return mT0;
}

//-------------------------------------  Get the End time.
Time
Sine::getTEnd(void) const {
    return mTl;
}

//-------------------------------------  Get the Critical time.
Time
Sine::getTc(void) const {
    return mTc;
}

//-------------------------------------  Time versus Frequency.
Time
Sine::TvsF(double f) const {
    return mT0;
}

//-------------------------------------  Waveform Frequency.
double
Sine::freq(const Time& t) const {
    return mOmega/twopi;
}

//-------------------------------------  Waveform Phase angle.
double
Sine::phi(const Time& t) const {
    return mOmega*double(t-mTc)+mPhic;
}

//-------------------------------------  Amplitude.
double 
Sine::Ampl(const Time& t) const {
    return mAmpl;
}

void
Sine::setAmp(double amp) {
    mAmpl = amp;
}
