/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef XSIL_TIME_HH
#define XSIL_TIME_HH

#include "xsil/xobj.hh"
#include <string>

class Time;

namespace xsil {
    class xobj;
    class Xwriter;

/**  The XSil %time class is equivalent to a parameter but contains an encoded
  *  %time stamp.
  *  @memo %XSIL %time parameter class.
  *  @author J. Zweizig.
  *  @version 1.1; Modified December 27, 1999.
  *  @ingroup IO_xsil
  */
class xsil_time : public xobj {
public:
    /**  Default constructor.
      *  @memo Default constructor.
      */
    xsil_time(void);

    /**  Data constructor.
      *  @memo default constructor.
      *  @param Name  Pointer to the %time Name string.
      *  @param Type  Pointer to the %time Type string.
      *  @param Value Pointer to the %time data string.
      */
    xsil_time(const char* Name, const char* Type=0, const char* Value=0);

    /**  Construct an xsil %time object from a GPS Time class object.
      *  @memo Data constructor.
      *  @param Name Pointer to the %time Name string.
      *  @param t    Reference to a Time object specifying the initial value.
      */
    xsil_time(const char* Name, const Time& t);

    /**  Destructor.
      *  @memo Destructor.
      */
    ~xsil_time(void);

    /**  Write %time object to an XML file.
      *  @memo Write %time object to an XML file
      *  @param xout XML output object to receive %time definition.
      */
    void Spew(Xwriter& xout) const;

    /**  Make an exact copy of this object.
      *  @memo Make an exact copy of this object.
      *  @return Pointer to the copy.
      */
    xsil_time* Clone(void) const;

    /**  Get the object type.
      *  @memo Get the object type.
      *  @return Pointer to the object type string.
      */
    const char* getObjType(void) const;

    /**  Get the %time value.
      *  @memo Get the %time value.
      *  @return Pointer to the %time value string.
      */
    Time getTime(void) const;

    /**  Get the %time value.
      *  @memo Get the %time value.
      *  @return Pointer to the %time value string.
      */
    const char* getValue(void) const;

    /**  Set the %time value.
      *  @memo Set the %time value.
      *  @param Value Pointer to the time value string.
      */
    void setValue(const char* Value);

    /**  Set the %time value from a unsigned int variable containing the 
      *  number of seconds since the start of the GPS epoch.
      *  @memo Set the %time from GPS seconds.
      *  @param Value %Time value in GPS seconds.
      */
    void setValue(unsigned int Value);

    /**  Set the %time value from a stl string.
      *  @memo Set the %time.
      *  @param Value %Time value string.
      */
    void setValue(const std::string& Value);

    /**  Set the %time value from a Time variable.
      *  @memo Set the %time from GPS %Time.
      *  @param Value Time value.
      */
    void setValue(const Time& Value);

private:
    std::string mValue;
};   // xsil::xsil_time

//======================================  inline methods
inline const char*
xsil_time::getValue(void) const {
    return mValue.c_str();
}

}    // namespace xsil


#endif  //  XSIL_TIME_HH
