/* -*- mode: c++; c-basic-offset: 3; -*- */
#ifndef XSIL_GENXML_HH
#define XSIL_GENXML_HH
#include "xsil/xobj.hh"
#include "xsil/attrList.hh"
#include <vector>
#include <string>


namespace xsil {
   class Xwriter;
   class genText;

   /**  The %genXml class contains the name and type fields common to (almost) 
    *  all of the XSil data objects. It also provides a standard interface 
    *  to put objects of different types into tree structures, scan the trees
    *  and print the XML document defined by the tree.
    *  @memo %XSIL object base class
    *  @author J. Zweizig
    *  @version 1.1; Modified December 13, 1999
    *  @ingroup IO_xsil
    */
   class genXml : public xobj {
   public:

      /**  Default (null) constructor.
       *  @memo Null constructor.
       */
      genXml(void);

      /**  Data constructor
       *  @memo Data constructor
       *  @param Name Pointer to the object name string
       *  @param Type Pointer to the object type string
       */
      genXml(const char* objty, const attr_list& attr);

      /**  Default (null) constructor.
       *  @memo Null constructor.
       */
      genXml(const genXml& x);

      /**  Object destructor.
       *  @memo Object destructor.
       */
      virtual ~genXml(void);

      /**  Write the Object and any embedded object to an XML file.
       *  @memo Write the object to an XML file
       *  @param ostr XML output file descriptor.
       */
      virtual void Spew(xsil::Xwriter& ostr) const;

      xobj* addObject(const xobj& object);

      xobj* addObject(xobj* object);	

      genText* addString(const std::string& text);
	
      /**  Get the object type
       *  @memo Get the object type
       *  @return pointer to the object type string.
       */
      virtual const char* getObjType(void) const;

      /**  Create an identical copy(clone) of the current object.
       *  @memo Clone an object
       *  @return Pointer to the newly created clone
       */
      virtual genXml* Clone(void) const;

      /**  Test whether object is a container for generic object API. The
       *  default %genXml code returns false. This must be overridden by
       *  container classes.
       *  \brief Test if this is a container.
       *  \return True if the object is a container.
       */
      virtual bool container(void) const;

      /**  Find object with the specified name and type inside a container. 
       *  The first object in the container matching the specified type and
       *  name is returned. If the type or name are specified as an empty 
       *  string, any type or name is considered to match. Find returns a 
       *  null pointer if the object is not a container or if the specified
       *  name isn't found. The default %genXml implementation returns a NULL
       *  for all names. This should be overridden by any container object.
       *  @memo find an object.
       *  @param nm Name of requested object.
       *  @param ty Type of requested object.
       *  @return Constant pointer to the requested object or NULL.
       */
      virtual const xobj* find(const std::string& nm, 
			       const std::string& ty="") const;

      /**  Find object with the specified name and type inside a container.
       *  The first object in the container matching the specified type and
       *  name is returned. If the type or name are specified as an empty 
       *  string, any type or name is considered to match. Find returns a 
       *  null pointer if the object is not a container or if the specified
       *  name isn't found. The default %genXml implementation returns a NULL
       *  for all names. This should be overridden by any container object.
       *  @memo find an object.
       *  @param nm Name of requested object.
       *  @param ty Type of requested object.
       *  @return Pointer to the requested object or NULL.
       */
      virtual xobj* find(const std::string& nm, 
			 const std::string& ty="");

      /**  Find object recursively in a container.
       *  @memo find an object recursively.
       *  @param nm Name of requested object.
       *  @param ty Type of requested object.
       *  @return Pointer to the requested object or NULL.
       */
      virtual const xobj* findr(const std::string& nm, 
				const std::string& ty="") const;

      /**  Find object recursively in a container.
       *  @memo find an object recursively.
       *  @param nm Name of requested object.
       *  @param ty Type of requested object.
       *  @return Pointer to the requested object or NULL.
       */
      virtual xobj* findr(const std::string& nm, 
			  const std::string& ty="");

   private:
      std::string        mObjType;
      attr_list          mObjAttr;
      std::vector<xobj*> mObjList;
   };

   //--------------------------------------  Inline functions
   inline bool
   xsil::genXml::container(void) const {
      return true;
   }

   inline const char*
   xsil::genXml::getObjType(void) const {
      return mObjType.c_str();
   }
}

#endif  //  XSIL_GENXML_HH
