/* -*- mode: c++; c-basic-offset: 3; -*- */
#ifndef XSIL_GENTEXT_HH
#define XSIL_GENTEXT_HH
#include "xsil/xobj.hh"
#include <string>

namespace xsil {
   class Xwriter;

   /**  The %genText class contains the name and type fields common to (almost) 
    *  all of the XSil data objects. It also provides a standard interface 
    *  to put objects of different types into tree structures, scan the trees
    *  and print the XML document defined by the tree.
    *  @memo %XSIL object base class
    *  @author J. Zweizig
    *  @version 1.1; Modified December 13, 1999
    *  @ingroup IO_xsil
    */
   class genText : public xobj {
   public:

      /**  Default (null) constructor.
       *  @memo Null constructor.
       */
      genText(void);

      /**  Data constructor
       *  @memo Data constructor
       *  @param Name Pointer to the object name string
       *  @param Type Pointer to the object type string
       */
      genText(const std::string& txt);

      /**  Object destructor.
       *  @memo Object destructor.
       */
      virtual ~genText(void) {}

      /**  Write the Object and any embedded object to an XML file.
       *  @memo Write the object to an XML file
       *  @param ostr XML output file descriptor.
       */
      void Spew(xsil::Xwriter& ostr) const;

      void addString(const std::string& text);
	
      /**  Get the object type
       *  @memo Get the object type
       *  @return pointer to the object type string.
       */
      const char* getObjType(void) const;

      /**  Create an identical copy(clone) of the current object.
       *  @memo Clone an object
       *  @return Pointer to the newly created clone
       */
      genText* Clone(void) const;

      /**  Test whether object is a container for generic object API. The
       *  default %genText code returns false. This must be overridden by
       *  container classes.
       *  \brief Test if this is a container.
       *  \return True if the object is a container.
       */
      virtual bool container(void) const;

   private:
      std::string        mText;
   };

   //--------------------------------------  Inline functions
   inline bool
   xsil::genText::container(void) const {
      return false;
   }

   inline const char*
   xsil::genText::getObjType(void) const {
      return "genText";
   }
}

#endif  //  XSIL_GENTEXT_HH
