#include "sockutil.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>

#ifndef SOL_TCP
#define SOL_TCP IPPROTO_TCP
#endif

int
keepAliveTCP(int s, int idle, int intvl, int cnt) {
   int optval = 0;
   if (idle) {
#if TCP_KEEPIDLE
      /*  Set the keep-alive idle parameter */
      if (setsockopt(s, SOL_TCP, TCP_KEEPIDLE, &idle, sizeof(int))) {
         perror("Error in setsockopt(TCP_KEEPIDLE)");
         return 0;
      }

      /*  Set the keep-alive interval parameter */
      if (setsockopt(s, SOL_TCP, TCP_KEEPINTVL, &intvl, sizeof(int))) {
         perror("Error in setsockopt(TCP_KEEPINTVL)");
         return 0;
      }

      /*  Set the keep-alive count parameter */
      if (setsockopt(s, SOL_TCP, TCP_KEEPCNT, &cnt, sizeof(int))) {
         perror("Error in setsockopt(TCP_KEEPCNT)");
         return 0;
      }
#else /* TCP_KEEPIDLE */
      /*  Set the keep-alive idle parameter */
      if (setsockopt(s, IPPROTO_TCP, TCP_KEEPALIVE, &idle, sizeof(int))) {
         perror("Error in setsockopt(TCP_KEEPALIVE)");
         return 0;
      }
#endif /* TCP_KEEPIDLE */
      optval = 1;
   }

   /*  Enable/disable the keep-alive protocol. */
   if (setsockopt(s, SOL_SOCKET, SO_KEEPALIVE, &optval, sizeof(optval))) {
      perror("Error in setsockopt(SO_KEEPALIVE)");
      return 0;
   }
   return 1;
}
