/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef HTML_TEXTATTR_HH
#define HTML_TEXTATTR_HH

#include "Attrib.hh"

namespace html {
    class color;
    class size;
    class font;

    /**  @memo Text data attribute API
      *  The textAttr class holds the text attributes.
      *  @author J. Zweizig
      *  @version "$Header: https://redoubt.ligo-wa.caltech.edu/svn/gds/trunk/IO/html/textAttr.hh 6385 2010-12-10 23:00:42Z john.zweizig@LIGO.ORG $"
      *  @ingroup IO_html
      */
    class textAttr : public attList {
    public:
	/**  Construct a text attribute list.
	  *  @brief Constructor.
	  */
	textAttr(void);

	/**  Destroy a text attribute list.
	  *  @brief destructor.
	  */
	virtual ~textAttr(void) {}

	/**  Get the color attribute.
	  *  @brief Get the color.
	  *  @return Color attribute.
	  */
	const color& getColor(void) const;

	/**  Get the font type attribute.
	  *  @brief Get the font.
	  *  @return Font attribute.
	  */
	const font&  getFont(void) const;

	/**  Get the font size attribute.
	  *  @brief Get the font size.
	  *  @return Size sttributue
	  */
	const size&  getSize(void) const;

	/**  Set the font face attribute.
	  *  @brief Set the font attribute
	  *  @param x New font attribute
	  */
	void setFont(const font& x);

	/**  Set the text color attribute.
	  *  @brief Set the color attribute
	  *  @param x New color attribute
	  */
	void setColor(const color& x);

	/**  Set the size attribute.
	  *  @brief set the size attribute
	  *  @param x new size attribute
	  */
	void setSize(const size& x);

	/**  Merge specified attribute list with the current attributes.
	  *  @brief Merge attribute lists.
	  *  @param x Attribute list to be merged.
	  */
	void merge(const textAttr& x);

	/**  Merge specified attribute list with the current attributes.
	  *  @brief Merge attribute lists.
	  *  @param x Attribute list to be merged.
	  */
	void merge(const attList& x) {
	    attList::merge (x); }

	/**  Remove any attributes in a specified list.
	  *  @brief Suppress specified attributes.
	  *  @param x List of attributes to be suppressed.
	  */
	void suppress(const textAttr& x);
    };

}
#endif  //  HTML_TEXTATTR_HH
