/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef HTML_OBJECT_HH
#define HTML_OBJECT_HH

namespace html {
  class writer;
  typedef int dim_type;

  /**  The HTML object class is an abstract class defining the API for any 
    *  HTML object to be displayed.
    *  @memo Abstract HTML Object API.
    *  @author   John Zweizig
    *  @version  1.0; Modified January 5, 2001
    *  @ingroup IO_html
    */
  class object {
  public:
    /**  Null object constructor
      */
    object(void);

    /**  Object destructor
     */
    virtual ~object(void);

    /**  Create an identical copy of the object. The clone is owned by
      *  the calling function and will not be deleted when the original
      *  is destroyed.
      *  @memo Clone an object.
      *  @return Pointer to the object clone.
      */
    virtual object* clone(void) const = 0;

    /**  Get the horizontal size of a printable object.
      *  @memo Get the object size in x.
      *  @return Horizontal size in points.
      */
    virtual dim_type getXSize(void) const;

    /**  Get the vertical size of a printable object.
      *  @memo Get the object size in y.
      *  @return Vertical size in points.
      */
    virtual dim_type getYSize(void) const;

    /**  Write the description of this object and all included objects
      *  in the case of a compound to an html file.
      *  @memo Write out the object.
      *  @param out HTML write to receive the object description.
      */
    virtual void write(writer& out) const;
  };

}

#endif  // HTML_OBJECT_HH
