/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef HTML_LINK_HH
#define HTML_LINK_HH

#include "html/compound.hh"
#include "html/Attrib.hh"
#include <memory>
#include <string>

namespace html {
  class writer;

  /**  The link class represents a reference to another html page. The 
    *  link is displayed a a text object which when click on links to
    *  the specified target address. If the text field is left 
    *  blank, the target address is used both for the text field and 
    *  the reference address. If the target address is empty, the HLINE
    *  is treated as an ordinary text field. No other check is made on 
    *  the validity of the target address by the link class.
    *  @memo Link to another HTML page.
    *  @author J. Zweizig
    *  @version 1.1; Modified May 29, 2001
    *  @ingroup IO_html
    */
  class link : public compound {
  public:
    /**  Construct an empty link.
      *  @memo Default constructor.
      */
    link(void);

    /**  Construct a link containing descriptive text and an address
      *  string.
      *  @memo Data constructor.
      *  @param txt    Text describing the link width.
      *  @param target Target URL
      */
    link (const std::string& txt, const std::string& target);

    /**  Destroy the link object.
      *  @memo Destructor.
      */
    ~link(void);

    /**  Create an identical link object and return a pointer.
      *  @memo Clone the link object.
      *  @return Pointer to the link clone.
      */
    link* clone(void) const;

    /**  Get the tag string.
     */
    const char* getTag(void) const;

    /**  Set the link target address to the specified value.
      *  @memo Set the link address.
      *  @param addr New link address.
      */
    void setAddr(const std::string& addr);

    /**  Set the link text to the specified value.
      *  @memo Set the link text.
      *  @param txt New link text.
      */
    void setText(const std::string& txt);

  private:
  };
}

#endif  // HTML_LINK_HH
