#include "html/hline.hh"
#include "html/genAttr.hh"
#include "html/writer.hh"

using namespace html;
static const char* hrTag = "hr";

//======================================  Default constructor
hline::hline(void) {
    setWidth("100%");
}

//======================================  Data constructor
hline::hline(const std::string& wid) {
    setWidth(wid);
}

//======================================  Destructor
hline::~hline(void) {
}

//======================================  Clone an hline
hline*
hline::clone(void) const {
    return new hline(*this);
}

//======================================  Write the hline.
void 
hline::write(writer& out) const {
    out.tagNData(hrTag, mAttr);
}

//======================================  Set the hline width
void 
hline::setWidth(const std::string& w) {
    mAttr.repAttr("width", genAttr(w));
}

//======================================  Set the hline width
void 
hline::setSize(const std::string& sz) {
    mAttr.repAttr("size", genAttr(sz));
}
