/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "html/align.hh"
#include "html/writer.hh"
#include <iostream>

using namespace std;

//======================================  Construct a default align specifier
html::align::align(void)
  : mMode(k_default)
{}

//======================================  Specify a align by name
html::align::align(const std::string& aln) {
    setAlign(aln);
}

//======================================  Align destructor
html::align::~align(void) {}

//======================================  Clone a align specifier
html::align*
html::align::clone(void) const {
    return new align(*this);
}

//======================================  Test for default align.
bool 
html::align::isDefault(void) const {
    return mMode == k_default;
}

//======================================  Print attribute list
void 
html::align::putAttr(writer& w) const {
    switch (mMode) {
    case k_left:
        w.text("left");
        break;
    case k_right:
        w.text("right");
	break;
    case k_center:
        w.text("center");
	break;
    default:
        break;
    }
}

//======================================  Set align to default.
void 
html::align::setDefault(void) {
    mMode = k_default;
}

//======================================  Set alignment.
void 
html::align::setAlign(const std::string& name) {
    mMode = k_default;
    if (name == "center")     mMode = k_center;
    else if (name == "right") mMode = k_right;
    else if (name == "left")  mMode = k_left;
    else if (name == "default") mMode = k_default;
    else cerr << "Invalid alignment: " << name << endl;
}

//======================================  Compare alignments.
bool 
html::align::operator==(const align& x) const {
    return mMode == x.mMode;
}




