#ifndef __EXTENSIONS__
#define __EXTENSIONS__
#endif
#include <iostream>
#include "framexmit/framerecv.hh"
#include "tconv.h"

#define DEBUG 

   using namespace std;
   using namespace framexmit;

   const int bufsize = 20 * 1024 * 1024 + packetSize;
   const int bufnum = 20;
   const char* const net = "225.0.0.1";
   const char* const interface = "10.4.0.0";
   const int port = frameXmitPort;
   //const char* const net = 0;
   const double averages = 100.0;

   int main (int argc, char* argv[])
   {
      int skipTotal = 0;
      int errTotal = 0;
      double maxDelay = 0.0;
      double meanDelay = 0.0;
      double delay = 0.0;
      int nDelay = 0;
      tainsec_t start;
      tainsec_t stop;
   
      frameRecv 	in (0);
   
      // open conection
      cout << "open connection at " << net << endl;
      if (!in.open (net, interface, port)) {
         cout << "open failed" << endl;
         return 1;
      }
   
      // allocate data buffer
      char*		p = new (nothrow) char [bufsize];
      if (p == 0) {
         cout << "memory allocation error" << endl;
         return 1;
      }
   
      // get a couple of data buffers
      while (1) {
      
         static int		skip = -1;
         static unsigned int 	oldseq = 0;
         unsigned int 	seq = 0;
         unsigned int 	timestamp;
         unsigned int 	duration;
      
      #ifdef DEBUG
         // this purge is only here to make the timing numbers acurate
         // this guarantees that at least one packet was received when
         // start = TAInow() is executed.
         while (!in.purge()) {
            timespec	wait = {0, 1000000};
            nanosleep (&wait, 0);
         };
      #endif
      
         start = TAInow();
         cout << "get data" << endl;
         int len = in.receive (p , bufsize, &seq, &timestamp, &duration);
         cout << "got data" << endl;
         stop = TAInow();
         if (len < 0) {
            cout << "shutdown receiver (" << len << ")" << endl;
            in.close();
            return 0;
         }
      
      	 // check data from buffer
         bool error = false;
//          for (int j = 0; j < len / (int)sizeof (int); j += 1000) {
//             if (*((int*)p + j) != j) {
//                error = true;
//             }
//          }
         if (error) {
            errTotal++;
            cout << "data error" << endl;
         }
         if (skip == -1) {
            skip = 0;
            oldseq = seq;
         }
         else {
            skip = (int)seq - (int)oldseq - 1;
	    oldseq = seq;
            if (skip > 0) {
               skipTotal += skip;
               cout << "skipped " << skip << " buffers" << endl;
            }
         }
      
      	 // calculate delay 
         delay = (double) (stop - start) / 1E9;
         if (skip == 0) {
            if (nDelay == 1) {
               meanDelay = delay;
               maxDelay = delay;
            }
            else {
               meanDelay = (1 - 1/averages) * meanDelay + 1/averages * delay;
            }
            nDelay++;
            maxDelay = max (delay, maxDelay);
         }	
      
      	 // status message
         cout << "rcvd " << seq << "/" << len / 1024 / 1024 << "MB at " << 
            timestamp % 1000000 << ":" << duration << " (err " << errTotal << 
            ", skip " << skipTotal << ") Delay " <<
            (int) (delay * 1E3) << " ms" << endl;
         // cout << " (mean " << (int) (meanDelay * 1E3) <<
            // " ms, max " << (int) (maxDelay * 1E3) <<  "ms)" << endl;
      };
   
      return 0;
   }
