/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef FRAME_LEN_TAB_HH
#define FRAME_LEN_TAB_HH

#include <map>
#include <string>

class FrameLenTab {
public:
    FrameLenTab(void);
    ~FrameLenTab(void);
    void reset(void);

    void addSym(const std::string& name, long val);

    /**  parseType parses the type string for a structure element and 
      *  returns a type string and the number of data elements of the 
      *  specified type.
      *  @return true if successful parse.
      */
    bool parseType(const std::string& name, std::string& type, long& val) const;
private:
    typedef std::map<std::string, long> len_map;
    typedef len_map::value_type len_node;
    len_map mLenMap;
};


#endif // !defined(FRAME_LEN_TAB_HH)
