/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//    Print a list of channels
//
#include <string.h>
#include <strings.h>
#include <iostream>
#include <iomanip>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include "DAQC_api.hh"
#include "NDS1Socket.hh"
#include "NDS2Socket.hh"

using namespace std;
using namespace sends;

int 
main(int argc, const char *argv[]) {
    int port=DAQD_PORT;

    const char*   ndsname = getenv("LIGONDSIP");
    if (!ndsname) ndsname = "131.215.115.67";
    bool debug = false;
    int gps = 0, dt = 2;

    //---------------------------------  Get the arguments.
    bool syntax = false;
    for (int i=1 ; i<argc-1 ; i++) {
        if (!strcmp(argv[i], "nds")) {
	    ndsname = argv[++i];
	} else if (!strcmp(argv[i], "gps")) {
	    gps = strtol(argv[++i], 0, 0);
	} else if (!strcmp(argv[i], "dt")) {
	    dt = strtol(argv[++i], 0, 0);
	} else if (!strcmp(argv[i], "port")) {
	    port = strtol(argv[++i], 0, 0);
	} else if (!strcmp(argv[i], "debug")) {
	    debug = true;
	} else {
	    cerr << "Invalid argument: " << argv[i] << endl;
	    syntax = true;
	    break;
	}
    }

    if (argc < 2 || syntax) {
	cerr << "Syntax: " << endl;
	cerr << "prdata [dt <secs>] [gps <start>] [debug]"
	     << " [nds <ip-address>] [port <ip-port>] \\" << endl
	     << "       <channel1> [... <channelN>]" 
	     << endl;
	return 1;
    }

    //---------------------------------  Open a daqd socket
    cout << "Opening a socket to ND sever on node " << ndsname << endl;
    DAQC_api* nds;
    if (port == DAQD_PORT) nds = new NDS1Socket(ndsname, port);
    else                   nds = new NDS2Socket(ndsname, port);
    if (!nds->isOpen()) {
        cerr << "Unable to open socket to NDS on node " << ndsname << endl;
	return 2;
    }
    nds->setDebug(debug);

    cout << "Getting available channels" << endl;
    vector<DAQDChannel> List;
    int rc = nds->Available(cUnknown, gps, List);
    if (rc <= 0) {
	cerr << "Error requesting available channels: " << rc << endl;
	return 3;
    }

    string chan = argv[argc-1];
    DAQC_api::const_channel_iter i;
    for (i=List.begin(); i != List.end(); ++i) {
	if (i->mName == chan) break;
    }
    if (i == List.end()) {
	cerr << "Unable to find channel: " << chan << endl;
	return 4;
    }

    if (!nds->AddChannel(*i)) {
	cerr << "AddChannel failed" << endl;
	return 5;
    }

    if (debug) cerr << "request data..." << endl;
    rc = nds->RequestData(gps, dt, 2.0);
    if (debug) cerr << "rc = " << rc << endl;
    if (rc < 0) return 6;

    if (debug) cerr << "receive data..." << endl;
    rc = nds->GetData(2.0);
    if (debug) cerr << "rc = " << rc << endl;
    if (rc < 0) return 7;

    i = nds->FindChannel(chan);
    int nWd = i->nwords(dt); 
    float* p = new float[nWd];

    if (debug) cerr << "get channel data.... ";
    int recWd = nds->GetChannelData(chan, p, nWd*sizeof(float));
    if (debug) cerr << "rc = " << recWd << endl;
    if (rc < 0) return 8;

    for (int j=0; j<recWd; j += 8) {
	int nk = (recWd-j >= 8) ? 8 : recWd-j;
	cout << j << " ";
	for (int k=0; k<nk; ++k) {
	    cout << " " << p[j+k];
	}
	cout << endl;
    }
    delete[] p;
    delete nds;
    return 0;
}

