/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "FrStatDataRef.hh"
#include "framecpp/FrStatData.hh"
#include "FrVectRef.hh"
#include "Time.hh"

using namespace std;

inline FrStatDataRef::stat_type*
refStat(FrStatDataRef::stat_ptr_type p) {
#ifndef FCPP_SHARED_PTRS
    return dynamic_cast<FrStatDataRef::stat_type*>(p);
#else
    return dynamic_cast<FrStatDataRef::stat_type*>(p.get());
#endif
}

//=====================================  Default constructor
FrStatDataRef::FrStatDataRef(void)
  : mOwner(false)
{
    clear();
}

//=====================================  Default constructor
FrStatDataRef::FrStatDataRef(stat_ptr_type x)
  : mOwner(false), mData(x)
{}

//=====================================  Default constructor
FrStatDataRef::FrStatDataRef(const string& name, const string& comment, 
		       const string& repr, long vsn, const Time& tStart, 
		       const Time& tEnd, void* det, FrVectRef& v) 
  : mOwner(false)
{
    clear();
    setStat(name, comment, repr, vsn, tStart, tEnd, det, v);
}

//=====================================  Destructor
FrStatDataRef::~FrStatDataRef(void) {
    clear();
}

//=====================================  Get reference to the data vector
FrVectRef
FrStatDataRef::getFrVect(void) const {
    return FrVectRef(refStat(mData)->RefData()[0]);
}

//=====================================  Get the end time
Time
FrStatDataRef::getEndTime(void) const {
    return Time(refStat(mData)->GetTimeEnd());
}

//=====================================  get the name
const char*
FrStatDataRef::getName(void) const {
    return refStat(mData)->GetName().c_str();
}

//=====================================  get the name
const char*
FrStatDataRef::getRepresentation(void) const {
    return refStat(mData)->GetRepresentation().c_str();
}

//=====================================  get the start time
Time
FrStatDataRef::getStartTime(void) const {
    return Time(refStat(mData)->GetTimeStart());
}

//=====================================  Get the version number
long
FrStatDataRef::getVersion(void) const {
    return refStat(mData)->GetVersion();

}

//=====================================  Default constructor
FrStatDataRef::stat_ptr_type
FrStatDataRef::replicate(void) const {
    return stat_ptr_type(new stat_type(*refStat(mData)));
}

//=====================================  Default constructor
void
FrStatDataRef::setStat(const string& name, const string& comment, 
		       const string& repr, long vsn, const Time& tStart, 
		       const Time& tEnd, void* det, FrVectRef& v) {

    stat_ptr_type s(new stat_type(name, comment, repr, tStart.getS(),
				  tEnd.getS(), vsn));

#ifndef FCPP_SHARED_PTRS
    refStat(s)->RefData().append(v.release(), false, true);
#else
    refStat(s)->RefData().append(v.release());
#endif
    refStat(s)->SetDetector( frdetector_pointer(
			     reinterpret_cast<FrameCPP::FrDetector*>(det)) );
    setStat(s, true);
}

//=====================================  Default constructor
void
FrStatDataRef::setStat(stat_ptr_type v, bool owner) {
    clear();
    mData  = v;
    mOwner = owner;
}
