/* version $Id: gdserr.h 6313 2010-09-17 17:25:05Z james.batch@LIGO.ORG $ */
/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Module Name: gdserr							*/
/*                                                         		*/
/* Module Description: Error message API	 			*/
/*									*/
/*                                                         		*/
/* Module Arguments: none				   		*/
/*                                                         		*/
/* Revision History:					   		*/
/* Rel   Date     Programmer  	Comments				*/
/* 0.1	 30Mar98  D. Sigg    	First release		   		*/
/*                                                         		*/
/* Documentation References:						*/
/*	Man Pages: gdserr.html						*/
/*	References: none						*/
/*                                                         		*/
/* Author Information:							*/
/* Name          Telephone       Fax             e-mail 		*/
/* Daniel Sigg   (509) 372-8336  (509) 372-2178  sigg_d@ligo.mit.edu	*/
/*                                                         		*/
/* Code Compilation and Runtime Specifications:				*/
/*	Code Compiled on: Ultra-Enterprise, Solaris 5.5.1		*/
/*	Compiler Used: sun workshop C 4.2				*/
/*	Runtime environment: sparc/solaris				*/
/*                                                         		*/
/* Code Standards Conformance:						*/
/*	Code Conforms to: LIGO standards.	OK			*/
/*			  Lint.			TBD			*/
/*			  ANSI			TBD			*/
/*			  POSIX			TBD			*/
/*									*/
/* Known Bugs, Limitations, Caveats:					*/
/*								 	*/
/*									*/
/*                                                         		*/
/*                      -------------------                             */
/*                                                         		*/
/*                             LIGO					*/
/*                                                         		*/
/*        THE LASER INTERFEROMETER GRAVITATIONAL WAVE OBSERVATORY.	*/
/*                                                         		*/
/*                     (C) The LIGO Project, 1996.			*/
/*                                                         		*/
/*                                                         		*/
/* California Institute of Technology			   		*/
/* LIGO Project MS 51-33				   		*/
/* Pasadena CA 91125					   		*/
/*                                                         		*/
/* Massachusetts Institute of Technology		   		*/
/* LIGO Project MS 20B-145				   		*/
/* Cambridge MA 01239					   		*/
/*                                                         		*/
/* LIGO Hanford Observatory				   		*/
/* P.O. Box 1970 S9-02					   		*/
/* Richland WA 99352					   		*/
/*                                                         		*/
/* LIGO Livingston Observatory		   				*/
/* 19100 LIGO Lane Rd.					   		*/
/* Livingston, LA 70754					   		*/
/*                                                         		*/
/*----------------------------------------------------------------------*/

#ifndef _GDS_ERR_H
#define _GDS_ERR_H

#ifdef __cplusplus
extern "C" {
#endif


/* Header File List: */


/* definitions */
#define MAXERRMSG  1024


/* main program */

/**
   @name Error Message API
   * The error mesage API allows error mesages, warnings and debug
   messaged generated by the gds system to be display on a central
   console. Include "gdserr.h" to use it.

   In order to run properly each message server must run an error
   message daemon (gdserrd) and they must be list in a the paramter
   file /gds/param/err/<SITE_PREFIX><IFO_PREFIX>/errlog.par. For 
   example, if there are two error message servers (10.1.0.56 and 
   10.1.0.76) listening at port 12345 and 5353 (5353 is default).

   \begin{verbatim}
   [server0]
   address=10.1.0.56
   port=12345

   [server1]
   server=10.1.0.76
   debug=no
   console=yes
   error=no   
   warning=no
   \end{verbatim}

   @memo Writes error messages to the GDS console
   @author Written Mar. 1998 by Daniel Sigg
   @version 0.5
   @see Error Message Log Daemon
************************************************************************/

/*@{*/		/* subset of GDS Parameter File API documentation */


/** Displays a message on the GDS system consoles.

    @param msg character string describing the message
    @return void
    @author DS, March 98
    @see Error Message API
************************************************************************/
   void gdsConsoleMessage (const char* msg);

/** Displays an error message on the GDS system consoles.

    @param msg character string describing the message
    @return void
    @author DS, March 98
    @see Error Message API
************************************************************************/
   void gdsErrorMessage (const char* msg);

#if 0
/** Displays an error message on the GDS system consoles using
    predefined error types.

    @param err number describing type or error
    @param msg character string describing the message
    @return error number
    @author DS, March 98
    @see Error Message API
************************************************************************/
   int gdsError (int err, const char* msg);
#endif

   int gdsErrorEx (int err, const char* msg, const char* file, int line);
#define gdsError(err, msg) gdsErrorEx (err, msg, __FILE__, __LINE__)


/** Displays a warning message on the GDS system consoles.

    @param msg character string describing the message
    @return void
    @author DS, March 98
    @see Error Message API
************************************************************************/
   void gdsWarningMessage (const char* msg);

/** Displays a debug message on the GDS system consoles. The macro
    gdsDebug (msg) can be used to print the debug message depending
    on the state of the DEBUG constant.

    @param msg character string describing the message
    @return void
    @author DS, March 98
    @see Error Message API
************************************************************************/
   void gdsDebugMessage (const char* msg);

   void gdsDebugMessageEx (const char* msg, const char* file, int line);

#ifdef DEBUG
/** Displays a debug message on the GDS system console knowing its number.

    @param msg character string describing the message
    @return void
    @author DS, March 98
    @see Error Message API
************************************************************************/
#define gdsDebug(msg) \
   gdsDebugMessageEx (msg, __FILE__, __LINE__)
#else
#define gdsDebug(msg) 
#endif

/** Copies standard output and standard error to the system console.
    This function should be called once at the beginning of a program.
    It will display all text sent to standard output (stdout) or the 
    standard error (stderr) as console messages and error messages on
    the system console, respectively. Standard input is not affected.
    Successive calls may or may not generate separate messages.

    @param stdOut redirects standard out if non-zero
    @param stdErr redirects standard error if non-zero
    @return 0 if successful, -1 otherwise
    @author DS, March 98
    @see Error Message API
************************************************************************/
   int gdsCopyStdToConsole (int stdOut, int stdErr);


/*@}*/

#ifdef __cplusplus
}
#endif

#endif /*_GDS_ERR_H */
