/* Version $Id: gdsLib2.h 6334 2010-10-25 17:42:55Z james.batch@LIGO.ORG $ */
#ifndef  GDSLIB2_H
#define GDSLIB2_H

/* 

   :TODO:  Some of these comments are wrong

---- 16K Exc  Points  -------------
    1-   99     LSC Filt EXC
  100-  200     LSC XEX
 1000- 1400	ITM
 1400- 1800	RMBS
 2200- 2400     MC2
 3400- 3600	FM
 3800- 4000  	ETMX
 4000- 4200	ETMY
 41000- 41999   ADCU EX XEX - foton calibrator outputs
 42000- 42999   ADCU EY XEX - foton calibrator outputs
---- 16K Test Points  -------------
10000-10099	LSC FILTERS
10100-10200	LSC EXTRAS / DAQ
11000-11200	ITM
11200-11400	ITM XTP
11400-11600	RMBS
11600-11800	RMBS XTP
12200-12400	MC2
12400-12600	MC2 XTP
13400-13599	FM
13600-13800	FM XTP
13800-13999	ETMX
14000-14199	ETMY
14200-14399	ETMX XTP
14400-14599	ETMY XTP

---- 2K Excitation Signals  ---------
20400-21000	ASC
21000-23800	SOS     ( and LOS sensors )
24000-24400	HEPI 1
24400-24500 	HEPI EX
24500-24800	HEPI 2
24800-24900	HEPI EY
25000-25100     IOO
26000-26800	HEPI 1
26800-27000 	HEPI EX
27000-27600	HEPI 2
27600-27800	HEPI EY

---- 2K Test Points  ---------------- 
30000-30200     IOO FILTERS
30200-30400     IOO EXTRAS
30400-30699	ASC FILTERS
30700-30999	ASC EXTRAS / DAQ
31000-33800	SOS  (and LOS sensors)
33800-33999 	SOS DAQ

34400-34799	HEPI MC1
34800-35199	HEPI MC2
35200-35599	HEPI RM
35600-35999	HEPI OUT
36000-36399	HEPI 1 DAQ
36400-36799	HEPI ETMX
36800-37199	HEPI ETMX DAQ
37200-37599	HEPI BS
37600-37999	HEPI ITMX
38000-38399	HEPI ITMY
38400-38799	HEPI 2 DAQ
38800-39199	HEPI ETMY
39200-39599	HEPI ETMY DAQ
*/

typedef struct GDS_TABLE {
        int tpNum[DAQ_GDS_TP_ASC_TP_NUM];
        int sysNum[DAQ_GDS_TP_ASC_TP_NUM];
        int filtNum[DAQ_GDS_TP_ASC_TP_NUM];
        int sigNum[DAQ_GDS_TP_ASC_TP_NUM];
}GDS_TABLE;

#define XTP_SLOT	0x1000

#define GDS_IOO_TP_SIZE		200
#define GDS_IOO_EXC_SIZE	100
#define GDS_IOO_VALID_EX_MIN   	25000
#define GDS_IOO_VALID_EX_MAX   	25099
#define GDS_IOO_VALID_XEX_LOW   -1
#define GDS_IOO_VALID_XEX_HI   	-1
#define GDS_IOO_VALID_TP_MIN   	30000
#define GDS_IOO_VALID_TP_MAX	30199
#define GDS_IOO_VALID_XTP_LOW  	30200
#define GDS_IOO_VALID_XTP_HI   	30399

#define GDS_ETMX_TP_SIZE	400
#define GDS_ETMX_EXC_SIZE	200
#define GDS_ETMX_VALID_EX_MIN  	3800
#define GDS_ETMX_VALID_EX_MAX  	4000
#define GDS_ETMX_VALID_XEX_LOW 	-1
#define GDS_ETMX_VALID_XEX_HI  	-1
#define GDS_ETMX_VALID_TP_MIN  	13800
#define GDS_ETMX_VALID_TP_MAX  	14000
#define GDS_ETMX_VALID_XTP_LOW 	14200
#define GDS_ETMX_VALID_XTP_HI  	14400

#define GDS_ETMY_TP_SIZE	400
#define GDS_ETMY_EXC_SIZE	200
#define GDS_ETMY_VALID_EX_MIN   4000
#define GDS_ETMY_VALID_EX_MAX   4200
#define GDS_ETMY_VALID_XEX_LOW  -1
#define GDS_ETMY_VALID_XEX_HI   -1
#define GDS_ETMY_VALID_TP_MIN   14000
#define GDS_ETMY_VALID_TP_MAX   14200
#define GDS_ETMY_VALID_XTP_LOW  14400
#define GDS_ETMY_VALID_XTP_HI   14600

#define GDS_HEPIX_TP_SIZE	400
#define GDS_HEPIX_EXC_SIZE	200
#define GDS_HEPIX_VALID_TP_MIN  36400
#define GDS_HEPIX_VALID_TP_MAX  36800
#define GDS_HEPIX_VALID_EX_MIN  26800
#define GDS_HEPIX_VALID_EX_MAX  27000
#define GDS_HEPIX_VALID_XTP_LOW	36800
#define GDS_HEPIX_VALID_XTP_HI	37200
#define GDS_HEPIX_VALID_XEX_LOW -1
#define GDS_HEPIX_VALID_XEX_HI  -1

#define GDS_HEPIY_TP_SIZE	400
#define GDS_HEPIY_EXC_SIZE	200
#define GDS_HEPIY_VALID_TP_MIN  38800
#define GDS_HEPIY_VALID_TP_MAX  39200
#define GDS_HEPIY_VALID_EX_MIN  27600
#define GDS_HEPIY_VALID_EX_MAX  27800
#define GDS_HEPIY_VALID_XTP_LOW	39200
#define GDS_HEPIY_VALID_XTP_HI	39600
#define GDS_HEPIY_VALID_XEX_LOW	-1
#define GDS_HEPIY_VALID_XEX_HI 	-1

#define GDS_HEPI1_TP_SIZE	400
#define GDS_HEPI1_EXC_SIZE	200
#define GDS_HEPI1_VALID_TP_MIN  34400
#define GDS_HEPI1_VALID_TP_MAX  36000
#define GDS_HEPI1_VALID_EX_MIN  26000
#define GDS_HEPI1_VALID_EX_MAX  26800
#define GDS_HEPI1_VALID_XTP_LOW	36000
#define GDS_HEPI1_VALID_XTP_HI	36399
#define GDS_HEPI1_VALID_XEX_LOW	-1
#define GDS_HEPI1_VALID_XEX_HI 	-1

#define GDS_HEPI2_TP_SIZE	400
#define GDS_HEPI2_EXC_SIZE	200
#define GDS_HEPI2_VALID_TP_MIN  37200
#define GDS_HEPI2_VALID_TP_MAX  38400
#define GDS_HEPI2_VALID_EX_MIN  27000
#define GDS_HEPI2_VALID_EX_MAX  27600
#define GDS_HEPI2_VALID_XTP_LOW	38400
#define GDS_HEPI2_VALID_XTP_HI	38800
#define GDS_HEPI2_VALID_XEX_LOW	-1
#define GDS_HEPI2_VALID_XEX_HI 	-1

#ifdef CIT_40M
#define GDS_ASC_TP_SIZE		600
#define GDS_ASC_EXC_SIZE	400
#define GDS_ASC_VALID_EX_MIN   	24000
#define GDS_ASC_VALID_EX_MAX   	24400
#define GDS_ASC_VALID_XEX_LOW   -1
#define GDS_ASC_VALID_XEX_HI   	-1
#define GDS_ASC_VALID_TP_MIN   	34400
#define GDS_ASC_VALID_TP_MAX	35000
#define GDS_ASC_VALID_XTP_LOW  	35000
#define GDS_ASC_VALID_XTP_HI   	35399
#else
#define GDS_ASC_TP_SIZE		400
#define GDS_ASC_EXC_SIZE	400
#define GDS_ASC_VALID_EX_MIN   	20400
#define GDS_ASC_VALID_EX_MAX   	20999
#define GDS_ASC_VALID_XEX_LOW   -1
#define GDS_ASC_VALID_XEX_HI   	-1
#define GDS_ASC_VALID_TP_MIN   	30400
#define GDS_ASC_VALID_TP_MAX	30699
#define GDS_ASC_VALID_XTP_LOW  	30700
#define GDS_ASC_VALID_XTP_HI   	30870
#endif

#ifdef CIT_40M
#define GDS_SOS_TP_SIZE		200
#define GDS_SOS_EXC_SIZE	100
#else
#define GDS_SOS_TP_SIZE		800
#define GDS_SOS_EXC_SIZE	800
#endif
#define GDS_SOS_VALID_EX_MIN   	21000
#ifdef CIT_40M
#define GDS_SOS_VALID_EX_MAX   	22000
#else
#define GDS_SOS_VALID_EX_MAX   	21400
#endif
#define GDS_SOS_VALID_XEX_LOW   -1
#define GDS_SOS_VALID_XEX_HI   	-1
#define GDS_SOS_VALID_TP_MIN   	31000
#define GDS_SOS_VALID_TP_MAX   	33700
#define GDS_SOS_VALID_XTP_LOW	33800
#define GDS_SOS_VALID_XTP_HI	34000

#ifdef CIT_40M
#define GDS_LSC_TP_SIZE		200
#define GDS_LSC_EXC_SIZE	100
#define GDS_LSC_VALID_EX_MIN   	1
#define GDS_LSC_VALID_EX_MAX   	60
#define GDS_LSC_VALID_XEX_LOW  	100
#define GDS_LSC_VALID_XEX_HI   	112
#define GDS_LSC_VALID_TP_MIN   	10000
#define GDS_LSC_VALID_TP_MAX   	10200
#define GDS_LSC_VALID_XTP_LOW  	10200
#define GDS_LSC_VALID_XTP_HI   	10400
#else
#define GDS_LSC_TP_SIZE		400
#define GDS_LSC_EXC_SIZE	100
#define GDS_LSC_VALID_EX_MIN   	1
#define GDS_LSC_VALID_EX_MAX   	35
#define GDS_LSC_VALID_XEX_LOW  	100
#define GDS_LSC_VALID_XEX_HI   	114
#define GDS_LSC_VALID_TP_MIN   	10000
#define GDS_LSC_VALID_TP_MAX   	10199
#define GDS_LSC_VALID_XTP_LOW  	10200
#define GDS_LSC_VALID_XTP_HI   	10280
#endif

#ifdef CIT_40M
#define GDS_SUS1_TP_SIZE	200
#define GDS_SUS1_EXC_SIZE	100
#define GDS_SUS1_VALID_TP_MIN	11000
#define GDS_SUS1_VALID_TP_MAX	11800
#define GDS_SUS1_VALID_EX_MIN	1000
#define GDS_SUS1_VALID_EX_MAX	1400
#define GDS_SUS1_VALID_XTP_LOW	12600
#define GDS_SUS1_VALID_XTP_HI	12700
#define GDS_SUS1_VALID_XEX_LOW 	-1
#define GDS_SUS1_VALID_XEX_HI	-1

#else
#define GDS_SUS1_TP_SIZE	200
#define GDS_SUS1_EXC_SIZE	200
#define GDS_SUS1_VALID_TP_MIN	11000
#define GDS_SUS1_VALID_TP_MAX	11200
#define GDS_SUS1_VALID_EX_MIN	1000
#define GDS_SUS1_VALID_EX_MAX	1400
#define GDS_SUS1_VALID_XTP_LOW	11200
#define GDS_SUS1_VALID_XTP_HI	11220
#define GDS_SUS1_VALID_XEX_LOW 	-1
#define GDS_SUS1_VALID_XEX_HI	-1
#endif

#ifdef CIT_40M
#define GDS_SUS2_TP_SIZE	200
#define GDS_SUS2_EXC_SIZE	100
#define GDS_SUS2_VALID_TP_MIN   11800
#define GDS_SUS2_VALID_TP_MAX   12600
#define GDS_SUS2_VALID_EX_MIN   1400
#define GDS_SUS2_VALID_EX_MAX   1800
#define GDS_SUS2_VALID_XTP_LOW	12700
#define GDS_SUS2_VALID_XTP_HI	12760
#define GDS_SUS2_VALID_XEX_LOW 	-1
#define GDS_SUS2_VALID_XEX_HI	-1
#else
#define GDS_SUS2_TP_SIZE	200
#define GDS_SUS2_EXC_SIZE	200
#define GDS_SUS2_VALID_TP_MIN   11400
#define GDS_SUS2_VALID_TP_MAX   11600
#define GDS_SUS2_VALID_EX_MIN   1400
#define GDS_SUS2_VALID_EX_MAX   1799
#define GDS_SUS2_VALID_XTP_LOW	11600
#define GDS_SUS2_VALID_XTP_HI	11640
#define GDS_SUS2_VALID_XEX_LOW 	-1
#define GDS_SUS2_VALID_XEX_HI	-1
#endif

#define GDS_SUS3_TP_SIZE	200
#define GDS_SUS3_EXC_SIZE	200
#define GDS_SUS3_VALID_TP_MIN	12200
#define GDS_SUS3_VALID_TP_MAX	12399
#define GDS_SUS3_VALID_EX_MIN	2200
#define GDS_SUS3_VALID_EX_MAX	2399
#define GDS_SUS3_VALID_XTP_LOW	12400
#define GDS_SUS3_VALID_XTP_HI	12410
#define GDS_SUS3_VALID_XEX_LOW 	-1
#define GDS_SUS3_VALID_XEX_HI	-1

#define GDS_SUS4_TP_SIZE	200
#define GDS_SUS4_EXC_SIZE	200
#define GDS_SUS4_VALID_TP_MIN	13400
#define GDS_SUS4_VALID_TP_MAX	13599
#define GDS_SUS4_VALID_EX_MIN	3400
#define GDS_SUS4_VALID_EX_MAX	3599
#define GDS_SUS4_VALID_XTP_LOW	13600
#ifdef CIT_40M
#define GDS_SUS4_VALID_XTP_HI	13690
#else
#define GDS_SUS4_VALID_XTP_HI	13610
#endif
#define GDS_SUS4_VALID_XEX_LOW 	-1
#define GDS_SUS4_VALID_XEX_HI	-1

#define GDS_ADCU1_TP_SIZE	400
#define GDS_ADCU1_EXC_SIZE	400
#define GDS_ADCU1_VALID_TP_MIN	-1
#define GDS_ADCU1_VALID_TP_MAX	-1
#define GDS_ADCU1_VALID_EX_MIN	-1
#define GDS_ADCU1_VALID_EX_MAX	-1
#define GDS_ADCU1_VALID_XTP_LOW	15000
#define GDS_ADCU1_VALID_XTP_HI	15200
#define GDS_ADCU1_VALID_XEX_LOW -1
#define GDS_ADCU1_VALID_XEX_HI	-1

#define GDS_ADCU2_TP_SIZE	400
#define GDS_ADCU2_EXC_SIZE	400
#define GDS_ADCU2_VALID_TP_MIN	-1
#define GDS_ADCU2_VALID_TP_MAX	-1
#define GDS_ADCU2_VALID_EX_MIN	-1
#define GDS_ADCU2_VALID_EX_MAX	-1
#define GDS_ADCU2_VALID_XTP_LOW	15200
#define GDS_ADCU2_VALID_XTP_HI	15400
#define GDS_ADCU2_VALID_XEX_LOW -1
#define GDS_ADCU2_VALID_XEX_HI	-1

#define GDS_ADCU3_TP_SIZE	400
#define GDS_ADCU3_EXC_SIZE	10
#define GDS_ADCU3_VALID_TP_MIN	-1
#define GDS_ADCU3_VALID_TP_MAX	-1
#define GDS_ADCU3_VALID_EX_MIN	-1
#define GDS_ADCU3_VALID_EX_MAX	-1
#define GDS_ADCU3_VALID_XTP_LOW	15400
#define GDS_ADCU3_VALID_XTP_HI	15600
#define GDS_ADCU3_VALID_XEX_LOW 41000
#define GDS_ADCU3_VALID_XEX_HI	41999

#define GDS_ADCU4_TP_SIZE	400
#define GDS_ADCU4_EXC_SIZE	10
#define GDS_ADCU4_VALID_TP_MIN	-1
#define GDS_ADCU4_VALID_TP_MAX	-1
#define GDS_ADCU4_VALID_EX_MIN	-1
#define GDS_ADCU4_VALID_EX_MAX	-1
#define GDS_ADCU4_VALID_XTP_LOW	15600
#define GDS_ADCU4_VALID_XTP_HI	15800
#define GDS_ADCU4_VALID_XEX_LOW 42000
#define GDS_ADCU4_VALID_XEX_HI	42999

#ifdef IOO
#define GDS_TP_SIZE		GDS_IOO_TP_SIZE
#define GDS_EXC_SIZE		GDS_IOO_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_IOO_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_IOO_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_IOO_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_IOO_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_IOO_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_IOO_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_IOO_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_IOO_VALID_XTP_HI
#endif

#ifdef ETMX
#define GDS_TP_SIZE		GDS_ETMX_TP_SIZE
#define GDS_EXC_SIZE		GDS_ETMX_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_ETMX_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_ETMX_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_ETMX_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_ETMX_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_ETMX_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_ETMX_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_ETMX_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_ETMX_VALID_XTP_HI
#endif

#ifdef ETMY
#define GDS_TP_SIZE		GDS_ETMY_TP_SIZE
#define GDS_EXC_SIZE		GDS_ETMY_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_ETMY_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_ETMY_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_ETMY_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_ETMY_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_ETMY_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_ETMY_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_ETMY_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_ETMY_VALID_XTP_HI
#endif

#ifdef HEPI_END_X
#define GDS_TP_SIZE		GDS_HEPIX_TP_SIZE
#define GDS_EXC_SIZE		GDS_HEPIX_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_HEPIX_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_HEPIX_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_HEPIX_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_HEPIX_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_HEPIX_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_HEPIX_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_HEPIX_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_HEPIX_VALID_XTP_HI
#endif

#ifdef HEPI_END_Y
#define GDS_TP_SIZE		GDS_HEPIY_TP_SIZE
#define GDS_EXC_SIZE		GDS_HEPIY_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_HEPIY_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_HEPIY_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_HEPIY_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_HEPIY_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_HEPIY_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_HEPIY_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_HEPIY_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_HEPIY_VALID_XTP_HI
#endif

#ifdef HEPI_HAM
#define GDS_TP_SIZE		GDS_HEPI1_TP_SIZE
#define GDS_EXC_SIZE		GDS_HEPI1_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_HEPI1_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_HEPI1_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_HEPI1_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_HEPI1_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_HEPI1_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_HEPI1_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_HEPI1_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_HEPI1_VALID_XTP_HI
#endif

#ifdef HEPI_BSC
#define GDS_TP_SIZE		GDS_HEPI2_TP_SIZE
#define GDS_EXC_SIZE		GDS_HEPI2_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_HEPI2_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_HEPI2_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_HEPI2_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_HEPI2_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_HEPI2_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_HEPI2_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_HEPI2_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_HEPI2_VALID_XTP_HI
#endif

#ifdef ASC
#define GDS_TP_SIZE		GDS_ASC_TP_SIZE
#define GDS_EXC_SIZE		GDS_ASC_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_ASC_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_ASC_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_ASC_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_ASC_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_ASC_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_ASC_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_ASC_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_ASC_VALID_XTP_HI
#endif

#ifdef SOS
#define GDS_TP_SIZE		GDS_SOS_TP_SIZE
#define GDS_EXC_SIZE		GDS_SOS_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_SOS_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_SOS_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_SOS_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_SOS_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_SOS_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_SOS_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_SOS_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_SOS_VALID_XTP_HI
#endif

#ifdef LSC_LVEA
#define GDS_TP_SIZE		GDS_LSC_TP_SIZE
#define GDS_EXC_SIZE		GDS_LSC_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_LSC_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_LSC_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_LSC_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_LSC_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_LSC_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_LSC_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_LSC_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_LSC_VALID_XTP_HI
#endif

#ifdef ITM
#define GDS_TP_SIZE		GDS_SUS1_TP_SIZE
#define GDS_EXC_SIZE		GDS_SUS1_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_SUS1_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_SUS1_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_SUS1_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_SUS1_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_SUS1_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_SUS1_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_SUS1_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_SUS1_VALID_XTP_HI
#endif

#ifdef RMBS
#define GDS_TP_SIZE		GDS_SUS2_TP_SIZE
#define GDS_EXC_SIZE		GDS_SUS2_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_SUS2_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_SUS2_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_SUS2_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_SUS2_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_SUS2_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_SUS2_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_SUS2_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_SUS2_VALID_XTP_HI
#endif

#ifdef FM
#define GDS_TP_SIZE		GDS_SUS4_TP_SIZE
#define GDS_EXC_SIZE		GDS_SUS4_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_SUS4_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_SUS4_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_SUS4_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_SUS4_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_SUS4_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_SUS4_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_SUS4_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_SUS4_VALID_XTP_HI
#endif

#ifdef MC2
#define GDS_TP_SIZE		GDS_SUS3_TP_SIZE
#define GDS_EXC_SIZE		GDS_SUS3_EXC_SIZE
#define GDS_VALID_EX_MIN    	GDS_SUS3_VALID_EX_MIN
#define GDS_VALID_EX_MAX     	GDS_SUS3_VALID_EX_MAX
#define GDS_VALID_XEX_LOW   	GDS_SUS3_VALID_XEX_LOW
#define GDS_VALID_XEX_HI    	GDS_SUS3_VALID_XEX_HI
#define GDS_VALID_TP_MIN    	GDS_SUS3_VALID_TP_MIN
#define GDS_VALID_TP_MAX     	GDS_SUS3_VALID_TP_MAX
#define GDS_VALID_XTP_LOW   	GDS_SUS3_VALID_XTP_LOW
#define GDS_VALID_XTP_HI    	GDS_SUS3_VALID_XTP_HI
#endif

#ifdef ADCU
#define GDS_TP_SIZE	400
#define GDS_EXC_SIZE	400
#define GDS_VALID_TP_MIN	-1
#define GDS_VALID_TP_MAX	-1
#define GDS_VALID_EX_MIN	-1
#define GDS_VALID_EX_MAX	-1
#define GDS_VALID_XTP_LOW	15000
#define GDS_VALID_XTP_HI	15800
#ifdef USE_DAC
#ifdef ADCU_EX
#  define GDS_VALID_XEX_LOW 	GDS_ADCU3_VALID_XEX_LOW
#  define GDS_VALID_XEX_HI	GDS_ADCU3_VALID_XEX_HI
#elif defined(ADCU_EY)
#  define GDS_VALID_XEX_LOW 	GDS_ADCU4_VALID_XEX_LOW
#  define GDS_VALID_XEX_HI	GDS_ADCU4_VALID_XEX_HI
#else
#  error Need to define whether EX or EY ADCU
#endif
#else
#define GDS_VALID_XEX_LOW -1
#define GDS_VALID_XEX_HI	-1
#endif
#endif

#define IS_GDS_ETMX_TP(tpnum) (((tpnum) >= GDS_ETMX_VALID_TP_MIN) && ((tpnum) < GDS_ETMX_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_ETMX_VALID_XTP_LOW) && ((tpnum) < GDS_ETMX_VALID_XTP_HI))
#define IS_GDS_ETMY_TP(tpnum) (((tpnum) >= GDS_ETMY_VALID_TP_MIN) && ((tpnum) < GDS_ETMY_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_ETMY_VALID_XTP_LOW) && ((tpnum) < GDS_ETMY_VALID_XTP_HI))

#define IS_GDS_HEPIX_TP(tpnum) (((tpnum) >= GDS_HEPIX_VALID_TP_MIN) && ((tpnum) < GDS_HEPIX_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_HEPIX_VALID_XTP_LOW) && ((tpnum) < GDS_HEPIX_VALID_XTP_HI))
#define IS_GDS_HEPIY_TP(tpnum) (((tpnum) >= GDS_HEPIY_VALID_TP_MIN) && ((tpnum) < GDS_HEPIY_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_HEPIY_VALID_XTP_LOW) && ((tpnum) < GDS_HEPIY_VALID_XTP_HI))
#define IS_GDS_HEPI1_TP(tpnum) (((tpnum) >= GDS_HEPI1_VALID_TP_MIN) && ((tpnum) < GDS_HEPI1_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_HEPI1_VALID_XTP_LOW) && ((tpnum) < GDS_HEPI1_VALID_XTP_HI))
#define IS_GDS_HEPI2_TP(tpnum) (((tpnum) >= GDS_HEPI2_VALID_TP_MIN) && ((tpnum) < GDS_HEPI2_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_HEPI2_VALID_XTP_LOW) && ((tpnum) < GDS_HEPI2_VALID_XTP_HI))

#define IS_GDS_ASC_TP(tpnum)   (((tpnum) >= GDS_ASC_VALID_TP_MIN) && ((tpnum) < GDS_ASC_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_ASC_VALID_XTP_LOW) && ((tpnum) < GDS_ASC_VALID_XTP_HI))

#define IS_GDS_SOS_TP(tpnum)   (((tpnum) >= GDS_SOS_VALID_TP_MIN) && ((tpnum) < GDS_SOS_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_SOS_VALID_XTP_LOW) && ((tpnum) < GDS_SOS_VALID_XTP_HI))

#define IS_GDS_LSC_TP(tpnum)   (((tpnum) >= GDS_LSC_VALID_TP_MIN) && ((tpnum) < GDS_LSC_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_LSC_VALID_XTP_LOW) && ((tpnum) < GDS_LSC_VALID_XTP_HI))

#define IS_GDS_SUS1_TP(tpnum)  (((tpnum) >= GDS_SUS1_VALID_TP_MIN) && ((tpnum) < GDS_SUS1_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_SUS1_VALID_XTP_LOW) && ((tpnum) < GDS_SUS1_VALID_XTP_HI))

#define IS_GDS_SUS2_TP(tpnum)  (((tpnum) >= GDS_SUS2_VALID_TP_MIN) && ((tpnum) < GDS_SUS2_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_SUS2_VALID_XTP_LOW) && ((tpnum) < GDS_SUS2_VALID_XTP_HI))

#define IS_GDS_SUS3_TP(tpnum)  (((tpnum) >= GDS_SUS3_VALID_TP_MIN) && ((tpnum) < GDS_SUS3_VALID_TP_MAX)\
			       ||((tpnum) >= GDS_SUS3_VALID_XTP_LOW) && ((tpnum) < GDS_SUS3_VALID_XTP_HI))


#define IS_GDS_ADCU1_TP(tpnum) (((tpnum) >= GDS_ADCU1_VALID_XTP_LOW) && ((tpnum) < GDS_ADCU1_VALID_XTP_HI))
#define IS_GDS_ADCU2_TP(tpnum) (((tpnum) >= GDS_ADCU2_VALID_XTP_LOW) && ((tpnum) < GDS_ADCU2_VALID_XTP_HI))
#define IS_GDS_ADCU3_TP(tpnum) (((tpnum) >= GDS_ADCU3_VALID_XTP_LOW) && ((tpnum) < GDS_ADCU3_VALID_XTP_HI))
#define IS_GDS_ADCU4_TP(tpnum) (((tpnum) >= GDS_ADCU4_VALID_XTP_LOW) && ((tpnum) < GDS_ADCU4_VALID_XTP_HI))
#define IS_GDS_ADCU_TP(tpnum)  (((tpnum) >= GDS_ADCU1_VALID_XTP_LOW) && ((tpnum) < GDS_ADCU4_VALID_XTP_HI))

#endif
