// Yo, Emacs! This is -*- C++ -*-
//
// $Id: TestParity.cc 7581 2016-02-29 02:44:31Z john.zweizig@LIGO.ORG $
//
// Author: David Chin <dwchin@umich.edu>
//
//         2477 Randall Lab, Univ. of Michigan
//         500 E. University Ave.
//         Ann Arbor, MI 48109
//         +1-734-764-5146
//         +1-734-730-1274
//
// Written based on idea by K. Riles <kriles@umich.edu>

#include "osc/TestParity.hh"
#include "Bits.hh"

using namespace std;


osc::TestParity::TestParity(DaccAPI          *access,
                            ostream        *outstream,
                            std::string     chanName,  // name of assoc. chan.
                            osc::IntParMap &intparams,
                            osc::DblParMap &dblparams,
                            int             debug)
    : OperStateCond(access, outstream, chanName, "valueabove", true,
                    intparams, dblparams, debug)
{
    // not sensible to return mCurResults.mDoubleVal, so make sure
    // it's zero
    mCurResults.mDoubleVal = 0.;
    
    return;
}


bool osc::TestParity::satisfied()
{
    if (mDebug > 0) {
        cout << "osc::TestParity on '" << mChannel
             << "': entered satisfied()" << endl;
    }

    // Read in data
    TSeries *ptx = dataSeries();

    // If the time series is empty, return false
    if (!ptx || ptx->empty())
        return false;

    // no. of samples
    size_t nSample = ptx->getNSample();

    // If this condition has already been checked for in the current
    // Frame, return the  buffered result.
    Time t0 = ptx->getStartTime();
    if (t0 == mCurResults.mT0) {
        return mCurResults.mSatisfiedP;
    } else {

        updateResultsBuffer();
        
        //
        // Current stuff
        //
        mCurResults.mT0 = t0;
        mCurResults.mDoubleVal = ptx->getMaximum();
	
        try {
            readParamsFromChanMaybe();
        }

        catch (DataRead_err &err) {
            err.printErrMsg();
            return false;
        }

        if (mDebug > 1) {
            cout << "osc::TestParity::satisfied: "
                 << "mIntParams[\"value\"].value() = "
                 << mIntParams["value"].value() << endl;
            cout << "osc::TestParity::satisfied: "
                 << "nSample = " << nSample << endl;
        }

	int nOdd = 0;
	int nEven = 0;
	for (size_t i=0; i<nSample; i++) {
	  if (odd_parity(ptx->refDVect()->getLong(i))) nOdd++;
	  else                                         nEven++;
	}

	int testval = mIntParams["value"].value();
	if (testval == 0)      mCurResults.mSatisfiedP = (nEven == nSample);
	else if (testval == 1) mCurResults.mSatisfiedP = (nOdd == nSample);
	else                   mCurResults.mSatisfiedP = (nOdd && nEven);
	if (mDebug > 1) {
	  if (mCurResults.mSatisfiedP)
	    cout << "osc::TestParity::satisfied: TRUE" << endl;
	  else
	    cout << "osc::TestParity::satisfied: FALSE" << endl;
	}

        // return current results
        return mCurResults.mSatisfiedP;
    }
}

