#ifndef __CINT__
#include "TSeries.hh"
#include "Dacc.hh"
#include "TH2.h"
#include "TCanvas.h"
#include "TROOT.h"
#include "TStyle.h"
#include "TText.h"

extern Dacc In;
#endif

void TXYPlot(const TSeries* ts1, const TSeries* ts2, const char* opts=0) {
    //----------------------------------  Formatting parameters
    float xmargin = 0.1;  // Fractional margin in x.
    float xbins   = 100.0; // Number of x bins
    float ymargin = 0.1;  // Fractional margin in x.
    float ybins   = 100.0; // Number of x bins

    if (!ts1 || !ts2) {
        cout << "TXYPlot: Invalid TSeries pointer." << endl;
	return;
    }

    //----------------------------------  Get important TSeries parameters.
    int nbin = ts1->getNSample();
    float stime = ts1->getStartTime().totalS();
    if (stime > 1000000.0) stime = 0;
    float step = ts1->getTStep().GetSecs();

    //----------------------------------  Get the data and real length.
    float* DVecX = new float[nbin];
    int nwd = ts1->getData(nbin,DVecX);

    float* DVecY = new float[nbin];
    if (nwd != ts2->getData(nbin,DVecY)) {
        cout << "X and Y time series are not the same length!" << endl;
	return;
    }
    float xmin = DVecX[0];
    float xmax = DVecX[0];
    float ymin = DVecY[0];
    float ymax = DVecY[0];
    for (int i=1 ; i<nwd ; i++) {
	if (DVecX[i] < xmin) xmin = DVecX[i];
	if (DVecX[i] > xmax) xmax = DVecX[i];
	if (DVecY[i] < ymin) ymin = DVecY[i];
	if (DVecY[i] > ymax) ymax = DVecY[i];
    }
    float xwidth = (xmax - xmin)/xbins;
    int iwid = int(xwidth + 1.0);
    float xlo = 0.5*(xmin + xmax - iwid*xbins);
    float xhi = xlo + iwid*xbins;

    float ywidth = (ymax - ymin)/ybins;
    int jwid = int(ywidth + 1.0);
    float ylo = 0.5*(ymin + ymax - jwid*ybins);
    float yhi = ylo + jwid*xbins;

    //----------------------------------  Create and fill the histogram.
    TH2F hist("TS001", "X-Y Plot", int(xbins), xlo, xhi, 
	                           int(ybins), ylo, yhi);
    for (int i=0 ; i<nwd ; i++) {
        hist.Fill(DVecX[i], DVecY[i]);
    }
    delete[] DVecX;
    delete[] DVecY;

    //----------------------------------  Set the plotting options
    gStyle->SetOptStat(0);
    if (gROOT->GetSelectedPad()) (gROOT->GetSelectedPad()->GetCanvas())->cd();
    if (gROOT->FindObject("padT")) delete gROOT->FindObject("padT");
    TPad* padT = new TPad("padT", "Time Series", 0.0, 0.0, 1.0, 1.0);
    padT->Draw();
    padT->cd();
    padT->SetBottomMargin(0.12);
    padT->SetLeftMargin(0.15);
    padT->SetTicks(1,1);
    hist.DrawCopy(opts);

    TText l1;
    l1.SetTextAlign(22);
    l1.SetTextSize(0.05);
    l1.SetTextAngle(90.);
    l1.DrawTextNDC(0.03, 0.50, ts2->getName());

    l1.SetTextAngle(0.);
    l1.DrawTextNDC(0.50, 0.03, ts1->getName());

    padT->GetCanvas()->Update();
}

void TXYPlot(const char *name1, const char *name2, const char *opts=0) {
    TSeries* ts1 = In.refData(name1);
    if (!ts1) cout << "TXYPlot: Can't find channel: " << name1 << endl;

    TSeries* ts2 = In.refData(name2);
    if (!ts2) cout << "TXYPlot: Can't find channel: " << name2 << endl;

    if (!ts1 || !ts2) return;
    TXYPlot(ts1, ts2, opts);
}
