//-------------------------------------  Histogram a TSeries
void THist(const TSeries* ts, const char* opts=0) {
    //---------------------------------  Formatting parameters
    float xmargin = 0.1;  // Fractional margin in x.
    float xbins   = 100.0; // Number of x bins

    if (!ts) {
        printf("THist: Invalid TSeries pointer.");
	return;
    }

    //----------------------------------  Get the important TSeries parameters.
    int nbin = ts->getNSample();
    float stime = ts->getStartTime().totalS();
    if (stime > 1000000.0) stime = 0;
    float step = ts->getTStep().GetSecs();

    //----------------------------------  Get the data and real length.
    float* DVec = new float[nbin];
    int nwd = ts->getData(nbin,DVec);
    float dtime = stime + step * nwd;
    float xmin = DVec[0];
    float xmax = DVec[0];
    for (int i=1 ; i<nwd ; i++) {
	if (DVec[i] < xmin) xmin = DVec[i];
	if (DVec[i] > xmax) xmax = DVec[i];
    }
    float xwidth = (xmax - xmin)/xbins;
    int iwid = xwidth + 1.0;
    float xlo = 0.5*(xmin + xmax - iwid*xbins);
    float xhi = xlo + iwid*xbins;

    //----------------------------------  Create and fill the histogram.
    TH1F hist("TS001", ts->getName(), int(xbins), xlo, xhi);
    for (int i=0 ; i<nwd ; i++) {
        hist.Fill(DVec[i]);
    }
    delete[] DVec;

    //----------------------------------  Set the plotting options
    gStyle->SetOptStat(0);
    if (gROOT->GetSelectedPad()) (gROOT->GetSelectedPad()->GetCanvas())->cd();
    if (gROOT->FindObject("padT")) delete gROOT->FindObject("padT");
    TPad* padT = new TPad("padT", "Time Series", 0.0, 0.0, 1.0, 1.0);
    padT->Draw();
    padT->cd();
    padT->SetBottomMargin(0.12);
    padT->SetLeftMargin(0.15);
    padT->SetTicks(1,1);
    hist.DrawCopy(opts);

    //---------------------------------- Label axes
    TText l1;
    l1.SetTextAlign(22);
    l1.SetTextSize(0.05);
    l1.SetTextAngle(90.);
    l1.DrawTextNDC(0.03, 0.50, "Samples / Bin");

    l1.SetTextAngle(0.);
    l1.DrawTextNDC(0.50, 0.03, "ADC Bin");

    padT->GetCanvas()->Update();
}

//-------------------------------------  Histogram a named TSeries
void THist(const char *name, const char *opts=0) {
    TSeries* ts = In.refData(name);
    if (!ts) {
        printf("THist: Could not find Time series for channel %s.\n", name);
	return;
    }
    THist(ts, opts);
}
