void 
ABSpectrum(const FSpectrum& a, const FSpectrum& b, const char* opts=0) {
    //----------------------------------  Formatting parameters
    float ymargin = 0.1;  // Fractional margin in y.

    //----------------------------------  Get the TSeries parameters.
    int    nbin = a.getNStep();
    float sfreq = a.getLowFreq();
    float  step = a.getFStep();

    //----------------------------------  Get the data and real length.
    float* DVecA = new float[nbin];
    int nwd = a.getData(nbin,DVecA);
    float* DVecB = new float[nbin];
    int nwd = b.getData(nbin,DVecB);
    float dfreq = sfreq + step * nwd;

    //----------------------------------  Create and fill the histogram.
    TH1F hista("S001a", a.getName(), nwd, sfreq, dfreq);
    TH1F histb("S001b", b.getName(), nwd, sfreq, dfreq);
    float ymin = DVecA[0];
    float ymax = DVecA[0];
    for (int i=0 ; i<nwd ; i++) {
        float x = DVecA[i];
        hista.SetBinContent(i+1, x);
	if ((ymin==0 || x < ymin) && x > 0) ymin = x;
	if (x > ymax) ymax = x;
        histb.SetBinContent(i+1, DVecB[i]);
    }
    delete[] DVecA;
    delete[] DVecB;
    //hista.SetMinimum(ymin);
    //hista.SetMaximum(ymax);
    //histb.SetMinimum(ymin);
    //histb.SetMaximum(ymax);

    //----------------------------------  Set the plotting options
    gStyle->SetOptStat(0);
    if (gROOT->GetSelectedPad()) (gROOT->GetSelectedPad()->GetCanvas())->cd();
    else                         new TCanvas("cGDS", "GDS Canvas");
    if (gROOT->FindObject("padT")) delete gROOT->FindObject("padT");
    TPad* padT = new TPad("padT", "Spectra", 0.0, 0.0, 1.0, 1.0);
    padT->Draw();
    padT->cd();
    padT->SetBottomMargin(0.12);
    padT->SetLeftMargin(0.15);
    padT->SetTicks(1,1);
    padT->SetLogx(1);
    padT->SetLogy(1);
    hista.SetLineColor(kRed);
    hista.DrawCopy(opts);
    histb.DrawCopy("SAME");

    //----------------------------------  Label y-axis
    TText text;
    text.SetTextAlign(22);
    text.SetTextSize(0.05);
    text.SetTextAngle(90.);
    text.DrawTextNDC(0.04, 0.50, "Power Spectrum (counts^2/Hz)");

    //----------------------------------  Label x-axis
    text.SetTextAngle(0.);
    text.DrawTextNDC(0.50, 0.04, "Frequency (Hz)");

    padT->GetCanvas()->Update();
}
