#ifndef GENERATOR_GENDET_HH
#define GENERATOR_GENDET_HH

namespace generator {

  /**  The genDet class contains the location and orientation of the detector
    *  being simulated. 
    *  @memo DMT data generator detector information class
    *  @version 1.0 ; Modified December 27, 2002
    *  @author John Zweizig
    */
  class GenDet {
  public:
    /**  Generate a detector in center earth. All values will be valid, 
      *  but the results of using a detector generated in this way will 
      *  be more than a bit fishy.
      *  @memo GenDet default constructor.
      */
    GenDet(void);

    /**  Define a detectors position and orientation. The position is 
      *  defined as a longitude, latitude and an altitude in 
      *  meters from nominal sea level. The orientation of the x and y
      *  arms are defines as angle west of north.
      *  @memo Construct detector information
      *  @param lng  Longitude in degrees, positive is east of GM.
      *  @param lat  Latitude in degrees, positive is north of equator.
      *  @param alt  Altitude in meters above sea level.
      *  @param xPhi Angle of the x arm in degrees west of north.
      *  @param yPhi Angle of the y arm in degrees west of north.
      */
    GenDet(double lng, double lat, double alt=0.0, 
	   double xPhi=0, double yPhi=90.0);
  private:
    double mLongitude;
    double mLatitude;
    double mAltitude;
    double mXPhi;
    double mYPhi;
  };

}
#endif // GENERATOR_GENDET_HH

