#include "DampedSine.hh"
#include <iostream>
#include <math.h>

using namespace std;

namespace generator {

  DampedSine::DampedSine(void) {
      setTriggerRate(1.0);
      setParameter("A",      1.0);
      setParameter("F",      1.0);
      setParameter("Q",      1.0);
      setParameter("Phi",    0.0);
      setParameter("Width", 18.0);
  }

  DampedSine::DampedSine(double Amp, double Freq, double Q, double Phi, double w)
  {
      setTriggerRate(1.0);
      setParameter("A",     Amp);
      setParameter("F",     Freq);
      setParameter("Q",     Q);
      setParameter("Phi",   Phi);
      setParameter("Width", w);
  }

  DampedSine::~DampedSine(void) {
  }

  DampedSine*
  DampedSine::clone(void) const {
      return new DampedSine(*this);
  }

  //====================================  Generate a damped sinusoid t-series
  void
  DampedSine::getSeries(const Time& t0, Interval dT, int N, gen_sample_type* d) {

      //--------------------------------  Get the parameters
      double Ampl   = getNumeric("A");
      double omega  = 2*M_PI*getNumeric("F");
      double Q      = getNumeric("Q");
      double Phi    = getNumeric("Phi")*M_PI/180;
      double Width  = getNumeric("Width");
      double tauinv = omega/Q;

      //-------------------------------  Get ready to loop
      double xWid = Width/tauinv;
      double xInc = dT;
      double xLow = double(t0 - getTrigTime());
      for (int i=0 ; i<N ; ++i) {
	  double x = xLow + double(i)*xInc;
	  if (x < 0.0) continue;
	  if (x > xWid) break;
	  d[i] += Ampl * sin(omega*x + Phi) * exp(-x*tauinv);
      }
  }

  //====================================  Get the full width (2*Width*sigma)
  Interval
  DampedSine::getDuration(void) const {
      double omega = getNumeric("F")*2*M_PI;
      double Q     = getNumeric("Q");
      double Width = getNumeric("Width");
      return Interval(Width*Q/omega);
  }

} // namespace generator
