#include "SvrTemplate.hh"
#include "xsil/MetaIO.hh"
#include <iostream>

EXECSVR(SvrTemplate)

using namespace std;

//======================================  Construct the server program
SvrTemplate::SvrTemplate(int argc, const char* argv[]) 
  : DMTServer(argc,argv) 
{
    bool syntax = false;
    for (int i=1; i<argc; ++i) {
        string argi = argv[i];
	if (argi == "-file") {
	    mFile = argv[++i];
	} else if (argi == "-table") {
	    mTable = argv[++i];
	} else if (isServerArg(argv[i])) {
	    ++i;
	} else {
	    cerr << "Unrecognized command line argument: " << argi << endl;
	    syntax = true;
	}
    }

    //-----------------------------------  Check the command line syntax
    if (mFile.empty()) syntax = true;
    if (syntax) {
        cerr << "Syntax error on command line" << endl;
	finish();
    }

    //-----------------------------------  Define objects to be served
    serveData("Trigger_Amplitude_vs_Time",   &mTS_X);
    serveData("Trigger_Count_vs_Time",       &mTS_N);
    serveData("Trigger_Amplitude_Histogram", &mHistX);
}

//======================================  Termination entry
SvrTemplate::~SvrTemplate(void) {
}

//======================================  Calculate objects to be served
void 
SvrTemplate::ProcessData(const Time& t) {
    xsil::MetaIO mio(mFile.c_str(), mTable.c_str());
    if (!mio.is_open()) {
        cerr << "Unable to open table: " << mTable << " of file: " << mFile 
	     << endl;
	return;
    }

    //----------------------------------  Allocate arrays for 24 hours of data
    long nBin = 60*24;
    Interval tStep(60.0);
    double* pN = new double[nBin];
    double* pX = new double[nBin];
    for (int i=0; i<nBin; ++i) {
        pN[i] = 0;
        pX[i] = 0;
    }

    Histogram1 hX("Trigger Size", 100, 0, 100.0);

    Time t0(0);
    while (!mio.getRow()) {
        Time t = Time(mio.getInt("start_time"));
	if (!t) {
	    cerr << "Trigger doesn't contain start time" << endl;
	    break;
	}

	if (!t0) {
	    long ts = t.getS();
	    t0 = Time(ts - (ts%60), 0);
	}

	double xSize = mio.getFloat("size", 0.0);
	if (t < t0) continue;
	long iBin = long(double((t-t0)/tStep));
	if (iBin > nBin) continue;

	hX.Fill(xSize);
	pN[iBin] += 1.0;
	pX[iBin] += xSize;
    }

    //-----------------------------------  Set the objects to be served
    for (int i=0; i<nBin; ++i) if (pN[i] != 0.0) pX[i] /= pN[i];
    mTS_N = TSeries(t0, tStep, nBin, pN);
    mTS_X = TSeries(t0, tStep, nBin, pX);
    mHistX = hX;

    //----------------------------------- free arrays
    delete[] pN;
    delete[] pX;    
}
