/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//    This is a C++ implementation of the FrameL I/O functions with C 
//    Linkages. The FrIO functions access either file I/O or shared memory
//    partitions. SM partitions are specified in the file name as 
//    "/online/<partition-name>"
//
#include "ONLFrIO.h"
#ifndef DMTOFFLINE
#include "lsmp_con.hh"
#endif
#include "SigFlag.hh"
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <iostream>
#include <errno.h>
#include <stdio.h>
using namespace std;

#define ONLINE_DEV "/online/"

/*------------------------------------ this is need for Windows NT --*/
#if !defined(O_BINARY)
#define O_BINARY 0
#endif

static int 
endFrame(const char* p, int len) {
    struct {int sLen; short sID, sInst;} h;
    short FrEndID = 0;
    for (int inx=40 ; inx < len ; inx+=h.sLen) {
	memcpy((char*)&h, p+inx, sizeof(h));
        if (h.sLen <= int(sizeof(h))) return 0;
	if (h.sID == 1) {
	    if (!strcmp(p+inx+sizeof(h)+2, "FrEndOfFrame")) {
	        short strlen(0);
		memcpy((char*)&strlen, p+inx+sizeof(h), 2);
	        memcpy((char*)&FrEndID, p+inx+sizeof(h)+2+strlen, 2);
	    }
	} else if (h.sID == FrEndID) {
	    return inx + h.sLen;
	}
    }
    printf("FrIORead: Couldn't find FrEndOfFrame structure\n");
    return 0;
}

//---------------------------------------  Open function.
struct FrIO *FrIOOpenR(char* filename) {

    //-----------------------------------  Construct/initialize FrIO structure
    struct FrIO* f = new FrIO;
    f->mode   = FrIO::null;
    f->fd     = -1;
    f->bufptr = (char*) 0;
    f->inx    = 0;
    f->end    = 0;
    f->gethdr = true;

    //-----------------------------------  Open consumer for online request
    int ltag = strlen(ONLINE_DEV);
    if (!strncmp(filename, ONLINE_DEV, ltag)) {
        #ifndef DMTOFFLINE
	f->consumer = new LSMP_CON(filename+ltag);
	if ((f->consumer)->valid()) f->mode = FrIO::online;
	else printf("FrIOOpenR: Couldn't open partition: %s\n", filename);
	#endif

    //-----------------------------------  Open a file.
    } else {
        // f->fd   = open(filename, flags, "r");
        f->fd = open(filename, O_RDONLY|O_BINARY, 0);
        if (f->fd >= 0) f->mode = FrIO::file;
    }
    if (f->mode != FrIO::null) return f;
    delete f;
    return 0;
}

//---------------------------------------  Open function.
struct FrIO *FrIOOpenW(char* filename) {

    //-----------------------------------  Construct/initialize FrIO structure
    struct FrIO* f = new FrIO;
    f->mode   = FrIO::null;
    f->fd     = -1;
    f->bufptr = (char*) 0;
    f->inx    = 0;
    f->end    = 0;
    f->gethdr = true;

    //-----------------------------------  Open consumer for online request
    int ltag = strlen(ONLINE_DEV);
    if (!strncmp(filename, ONLINE_DEV, ltag)) {
      // f->consumer = new LSMP_CON(filename+ltag);
      // if ((f->consumer)->valid()) f->mode = FrIO::online;

    //-----------------------------------  Open a file.
    } else {
        f->fd = open(filename,  O_CREAT|O_WRONLY|O_BINARY,0644);
	// f->fd   = open(filename, flags, mode);
        if (f->fd >= 0) f->mode = FrIO::file;
    }
    if (f->mode != FrIO::null) return f;
    delete f;
    return 0;
}

//---------------------------------------  Close the file, delete the structure
int FrIOClose(struct FrIO *f) {
    switch(f->mode) {
    case FrIO::null:
        break;
    case FrIO::file:
        close(f->fd);
	break;
    case FrIO::online:
        #ifndef DMTOFFLINE
        delete f->consumer;
	#else
	;
	#endif
    }
    delete f;
    return 0;
}

//---------------------------------------  Write to a file.
//                                         Note: output partitions are not
//                                               currently implemented.
int FrIOWrite(struct FrIO *f, char* buf, int nbyte) {
    switch(f->mode) {
    case FrIO::null:
        break;
    case FrIO::file:
        return write(f->fd, buf, nbyte);
    case FrIO::online:
        break;
    }
    return 0;
}

//--------------------------------------  Read N bytes from a file/partition.
int 
FrIORead(struct FrIO *f, char* buf, int nbyte) {
   switch(f->mode) {
    case FrIO::null:
        break;
    case FrIO::file:
        return read(f->fd, buf, nbyte);
    case FrIO::online:
        #ifndef DMTOFFLINE
        LSMP_CON* c = f->consumer;
        if (!f->bufptr) {
	    //cout << ">> ask for a new buffer" << endl;
	    f->bufptr = c->get_buffer();
	    if (!f->bufptr) return 0;
	    if (f->gethdr) {
	        f->inx = 0;
		f->gethdr = false;
	    } else {
	        f->inx = 40;
	    }

	    //--------------------------  Optional test of file length field
	    //                            Note: This doesn't work for frame
	    //                            versions > 5? or frames with 
	    //                            different byte swapping and has 
	    //                            therefore been commented out
	    #if 0
            unsigned int nBytes;
            memcpy((char *)&nBytes,  f->bufptr + c->getLength() - 16, 4);
            if (int(nBytes) != c->getLength()) {
		cout << "length mismatch:" << nBytes << c->getLength() << endl;
		return 0;
            } 
	    #endif
	    //---------------------------------------------------------------

	    f->end = endFrame(f->bufptr, c->getLength());
	    // printf("*** buffer length = %i\n", f->end);
        }
        int nb = f->end - f->inx;
	if (nbyte < nb) nb = nbyte;
	memcpy(buf, f->bufptr+f->inx, nb);
	f->inx += nb;
	if (f->inx == f->end) {
	    c->free_buffer();
	    f->bufptr = 0;
	}
        return nb;
	#else
	;
	#endif
    }
    return 0;
}

/*--------------------------------------------------------------------*/
int FrIOSet(struct FrIO *frfd, long offset)
/*--------------------------------------------------------------------*/
/* Set the file position (in bytes) from the file beggining
   returns -1 in case of error       */
 {return(-1);}

/*--------------------------------------------------------------------*/
int FrIOSetFromEnd(struct FrIO *frfd, long offset)
/*--------------------------------------------------------------------*/
/* Set the file position (in bytes) from the end of file
   returns -1 in case of error       */
{return(-1);}

/*--------------------------------------------------------------------*/
int FrIOSetFromCur(struct FrIO *frfd, long offset)
/*--------------------------------------------------------------------*/
/* Set the file position (in bytes) from the end of file
   returns -1 in case of error       */
 {return(-1);}

/*--------------------------------------------------------------------*/
long FrIOTell(struct FrIO *frfd)
/*--------------------------------------------------------------------*/
/* return the file position (in bytes)                                */

{return (0);}

