
#include "fdstream.hh"
#ifndef __GNU_STDC_OLD
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>


namespace gdsbase {

//______________________________________________________________________________
   int fdread (int fd, void* s, int num, int elsize)
   {
      // set descriptor to non-blocking
      int flags;
      if ((flags = fcntl (fd, F_GETFL, 0)) == -1) {
         return 0;
      }
      if (fcntl (fd, F_SETFL, flags | O_NONBLOCK) == -1) {
         return 0;
      }
      // read as many characters as possible
      int n = ::read (fd, s, num * elsize);
      // set descriptor back to its original state
      if (fcntl (fd, F_SETFL, flags) == -1) {
         return 0;
      }
      // return if something was read
      if (n > 0) {
         return n / elsize;
      }
      else if ((n != -1) && (errno != EAGAIN)) {
         return 0; // eof
      }
      // read one character and wait for answer
      n = ::read (fd, s, elsize);
      if (n > 0) {
         return n / elsize;
      }
      else {
         return 0;
      }
   }

//______________________________________________________________________________
   int fdwrite (int fd, const void* s, int num, int elsize)
   {
      int n = ::write (fd, (const void*)s, num * elsize);
      if (n > 0) {
         return n / elsize;
      }
      else {
         return 0;
      }
   }

//______________________________________________________________________________
   int fdseek (int fd, int offset, std::ios_base::seekdir way, int elsize)
   {
      int whence = 0;
      if (way == std::ios_base::beg) whence = SEEK_SET;
      if (way == std::ios_base::end) whence = SEEK_END;
      if (way == std::ios_base::cur) whence = SEEK_CUR;
      int pos = lseek (fd, offset * elsize, whence);
      if (pos == off_t(-1)) {
         return pos;
      }
      else {
         return pos / elsize;
      }
   }


}

#endif
