/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "format_spec.hh"
#include <sstream>
#include <iomanip>
#include <stdexcept>
#include <cstdlib>

using namespace table;
using namespace std;

//======================================  Constructor
format_spec::format_spec(void)
  : mNumFormat(kDefault), mPrecise(0), mWidth(0)
{}

//======================================  Constructor
format_spec::format_spec(const std::string& fmt)
  : mNumFormat(kDefault), mPrecise(0), mWidth(0)
{
    if (!fmt.empty()) parse(fmt);
}

//======================================  Destructor
format_spec::~format_spec(void) {
}

//======================================  Parse a format string
void
format_spec::parse(const std::string& fmt) {
    string::size_type len = fmt.size();
    for (string::size_type i=0; i<len; ) {
	char fmtch = fmt[i++];
	const char* pin  = fmt.c_str() + i;
	char*       pout = const_cast<char*>(pin);
	switch (fmtch) {
	case 'f':
	    setFixed(strtol(pin, &pout, 0));
	    break;
	case 'p':
	    setPrecision(strtol(pin, &pout, 0));
	    break;
	case 's':
	    setScientific(strtol(pin, &pout, 0));
	    break;
	case 'w':
	    mWidth = strtol(pin, &pout, 0);
	    break;
	default:
	    throw runtime_error(string("Unknown format: ") + fmtch);
	}
	i += pout - pin;
    }
}

//======================================  Put a string
std::string 
format_spec::put_string(double num) const {
  ostringstream ostr;
  if (mWidth) ostr << setw(mWidth);

  //------------------------------------  Convert float data
  switch (mNumFormat) {

  //------------------------------------  C++ default formatting.
  case kDefault: {
      //--------------------------------  Check for integer data
      long inum = num;
      if (double(inum) == num) ostr << inum;
      else                     ostr << setprecision(mPrecise) << num;
      break;
  }

  //------------------------------------  Fixed point notattion.
  case kFixed:
      ostr << fixed << setprecision(mPrecise) << num;
      break;

  //------------------------------------  Scientific notation
  case kSci:
      ostr << scientific << setprecision(mPrecise) << num;
      break;
  }

  //------------------------------------  Return the converted data
  return ostr.str();
}

//======================================  Set fixed point format
void 
format_spec::setFixed(int prec) {
  mNumFormat = kFixed;
  mPrecise   = prec;
}

//======================================  Set default format
void 
format_spec::setPrecision(int prec) {
  mNumFormat = kDefault;
  mPrecise   = prec;
  ;
}

//======================================  Set Scientific notation
void 
format_spec::setScientific(int prec) {
  mNumFormat = kSci;
  mPrecise   = prec;
}
