//////////////////////////////////////////////////////////////////////////
//  									//
//  Type								//
//  									//
//////////////////////////////////////////////////////////////////////////

#include <time.h>
#include <iostream>
#include "events/Type.hh"
#include "events/TypeInfo.hh"
#include "events/Factory.hh"

namespace events {

//______________________________________________________________________________
   Type::~Type () 
   {
      if (mInfo) mInfo->RefCount (false);
   }

//______________________________________________________________________________
   Type& Type::operator= (const Type& type)
   {
      if (this != &type) {
         if (mInfo) mInfo->RefCount (false);
         mInfo = type.mInfo;
         if (mInfo) mInfo->RefCount (true);
      }
      return *this;
   }

//______________________________________________________________________________
   bool Type::SetType (const char* name)
   {
      if (mInfo) mInfo->RefCount (false);
      Factory::Get().RegisterType (name, mInfo);
      if (mInfo) mInfo->RefCount (true);
      return (mInfo != 0);
   }

//______________________________________________________________________________
   const char* Type::GetName() const
   {
      return mInfo ? mInfo->GetName() : 0;
   }

//______________________________________________________________________________
   int Type::GetId () const
   {
      return mInfo ? mInfo->GetId() : 0;
   }

//______________________________________________________________________________
   const LayoutInfo* Type::GetLayout() const
   {
      return mInfo ? mInfo->GetLayout() : 0;
   }

//______________________________________________________________________________
   bool Type::Test (const char* name)
   {
      return Factory::Get().GetType (name) != 0;
   }

//______________________________________________________________________________
   bool Type::Match (const char* pat) const
   {
      return Factory::MatchType (*this, pat);
   }

//______________________________________________________________________________
   bool Type::CheckName (const char* name)
   {
      return Factory::CheckTypeName (name);
   }

//______________________________________________________________________________
   void Type::DumpAll (std::ostream& os)
   {
      Factory::Get().DumpAllTypes (os);
   }

//______________________________________________________________________________
   void Type::DumpAll ()
   {
      Factory::Get().DumpAllTypes (std::cout);
   }


}
