//////////////////////////////////////////////////////////////////////////
//  									//
//  Math								//
//  									//
//////////////////////////////////////////////////////////////////////////

#include <time.h>
#include "events/Math.hh"
#include "events/Window.hh"
#include "events/Argument.hh"


namespace events {

//______________________________________________________________________________
   bool Math::Evaluate (const Argument& arg, Value& val) const
   {
      // Need at least one argument
      Value v1;
      if (!mPtr1.Get() || !mPtr1->Evaluate (arg, v1)) {
         return false;
      }
      // If a second argument is provided evaluate it as well
      Value v2;
      if (mPtr2.Get() && !mPtr2->Evaluate (arg, v2)) {
         return false;
      }
      switch (mOp) {
         case opPos:
            {
               val = v1;
               break;
            }
         case opNeg:
            {
               val = -v1;
               break;
            }
         case opInc:
            {
               val = ++v1;
               break;
            }
         case opDec:
            {
               val = --v1;
               break;
            }
         case opAdd:
            {
               val = v1 + v2;
               break;
            }
         case opSub:
            {
               val = v1 - v2;
               break;
            }
         case opMul:
            {
               val = v1 * v2;
               break;
            }
         case opDiv:
            {
               val = v1 / v2;
               break;
            }
         case opMod:
            {
               val = v1 % v2;
               break;
            }
         case opAbs:
            {
               val = abs (v1);
               break;
            }
         case opSqrt:
            {
               val = sqrt (v1);
               break;
            }
         case opPow:
            {
               val = pow (v1, v2);
               break;
            }
         case opExp:
            {
               val = exp (v1);
               break;
            }
         case opLog:
            {
               val = log (v1);
               break;
            }
         case opLog10:
            {
               val = log10 (v1);
               break;
            }
         case opSin:
            {
               val = sin (v1);
               break;
            }
         case opCos:
            {
               val = cos (v1);
               break;
            }
         case opTan:
            {
               val = tan (v1);
               break;
            }
         case opAsin:
            {
               val = asin (v1);
               break;
            }
         case opAcos:
            {
               val = acos (v1);
               break;
            }
         case opAtan:
            {
               val = atan (v1);
               break;
            }
         case opAtan2:
            {
               val = atan2 (v1, v2);
               break;
            }
         case opSinh:
            {
               val = sinh (v1);
               break;
            }
         case opCosh:
            {
               val = cosh (v1);
               break;
            }
         case opTanh:
            {
               val = tanh (v1);
               break;
            }
         case opCeil:
            {
               val = ceil (v1);
               break;
            }
         case opFloor:
            {
               val = floor (v1);
               break;
            }
         case opNot:
            {
               val = ~v1;
               break;
            }
         case opAnd:
            {
               val = v1 & v2;
               break;
            }
         case opOr:
            {
               val = v1 | v2;
               break;
            }
         case opXor:
            {
               val = v1 ^ v2;
               break;
            }
         case opLeft:
            {
               val = v1 << v2;
               break;
            }
         case opRight:
            {
               val = v1 >> v2;
               break;
            }
         case opConj:
            {
               val = conj (v1);
               break;
            }
         case opPolar:
            {
               val = polar (v1, v2);
               break;
            }
         case opReal:
            {
               val = real (v1);
               break;
            }
         case opImag:
            {
               val = imag (v1);
               break;
            }
         case opArg:
            {
               val = events::arg (v1);
               break;
            }
         case opNorm:
            {
               val = norm (v1);
               break;
            }
         default:
            {
               return false;
            }
      }
      return true;
   }

//______________________________________________________________________________
   bool ShiftFunction::Evaluate (const Argument& arg, Value& val) const
   {
      // invalid parameters?
      if ((mShift < 0) || !mPtr.Get()) {
         return false;
      }
      // Shift at all?
      if (mShift == 0) {
         return mPtr->Evaluate (arg, val);
      }
      // Shift too many?
      if (mShift >= arg.GetOrder()) {
         return false;
      }
      // make a new argument list
      Window w = arg.GetWindow();
      w.GetCurrentList().erase (w.GetCurrentList().begin(), 
                           w.GetCurrentList().begin() + mShift);
      // evaluate on reduced list
      return mPtr->Evaluate (w, val);
   }

}
