//////////////////////////////////////////////////////////////////////////
//  									//
//  Comparison								//
//  									//
//////////////////////////////////////////////////////////////////////////

#include <time.h>
#include "events/Comparison.hh"
#include "events/Argument.hh"
#include "events/Value.hh"


namespace events {

//______________________________________________________________________________
   bool Comparison::Evaluate (const Argument& arg, bool& val) const
   {
      // Left hand side value
      Value v1;
      if (mCPtr1.Get()) {
         if (!ValueR (arg, v1)) {
            return false;
         }
      }
      else if (!mFPtr1.Get() || !mFPtr1->Evaluate (arg, v1)) {
         return false;
      }
      // Right hand side value
      Value v2;
      if (!mFPtr2.Get() || !mFPtr2->Evaluate (arg, v2)) {
         return false;
      }
      Value ret;
      switch (mOp) {
         case opEqual:
            {
               if (mTolerance > 0) {
                  ret = lessequal (abs (v2 - v1), mTolerance);
               }
               else {
                  ret = equal (v1, v2);
               }
               break;
            }
         case opUnequal:
            {
               ret = unequal (v1, v2);
               break;
            }
         case opLess:
            {
               ret = less (v1, v2);
               break;
            }
         case opLessEqual:
            {
               ret = lessequal (v1, v2);
               break;
            }
         case opGreater:
            {
               ret = greater (v1, v2);
               break;
            }
         case opGreaterEqual:
            {
               ret = greaterequal (v1, v2);
               break;
            }
         default:
            {
               return false;
            }
      }
      ColumnType::Int retval;
      if (!ret.Write (retval)) {
         return false;
      }
      val = (bool)retval;
      return true;
   }

//______________________________________________________________________________
   bool Comparison::ValueR (const Argument& arg, Value& val) const
   {
      if (mCPtr1.Get()) {
         const Comparison* comp = 
            dynamic_cast<const Comparison*>(mCPtr1.Get());
         if (comp) {
            return comp->ValueR (arg, val);
         }
         else {
            return false;
         }
      }
      else if (mFPtr2.Get()) {
         return mFPtr2->Evaluate (arg, val);
      }
      else {
         return false;
      }
   }

}
