#include <time.h>
#include "PConfig.h"
#include "web/xmlform.hh"
#include "Interval.hh"
#include "xml/Xsil.hh"
#include <string.h>
#include <strings.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <dirent.h>
#include <iostream>
#include <sstream>

namespace web {
   using namespace std;


   const double LISTING_TIMEOUT = 120;

   const char* const html_header =
   "<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">\n"
   "<html>\n"
   "<head>\n"
   "   <meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n"
   "   <meta name=\"Author\" content=\"Daniel Sigg\">\n"
   "   <meta name=\"GENERATOR\" content=\"xmlform (LIGO)\">\n"
   "   <title>XML Edit</title>\n"
   "</head>\n"
   "<body>";
   const char* const html_trailer =
   "</body>\n"
   "</html>";


//////////////////////////////////////////////////////////////////////////
//                                                                      //
// Utilities                                                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
#if 0
   static string mangle (const string& s)
   {
      const char* mark = "-_.!~*'()";
      const char* hex = "0123456789ABCDEF";
      string::size_type pos = 0;
      string r = s;
      while (pos < r.size()) {
         char c = r[pos];
         if (!isalnum (c) && (strchr (mark, c) == 0)) {
            string encode = 
               "%" + string (1, hex[c >> 4]) + string (1, hex[c&0x0F]);
            r.erase (pos, 1);
            r.insert (pos, encode);
         }
         ++pos;
      }
      return r;
   }
#endif

//______________________________________________________________________________
   static string demangle (const string& s)
   {
      string r = s;
      string::size_type pos = 0;
      while (pos + 2 < r.size()) {
         if ((r[pos] == '%') && isxdigit (r[pos+1]) && isxdigit (r[pos+2])) {
            char decode =
               (isdigit (r[pos+1]) ? r[pos+1]-'0' : 
               toupper (r[pos+1])-'A'+10) * 16 +
               (isdigit (r[pos+2]) ? r[pos+2]-'0' : 
               toupper (r[pos+2])-'A'+10);
            r.erase (pos, 3);
            r.insert (pos, string (1, decode));
         }
         ++pos;
      }
      return r;
   }

//______________________________________________________________________________
   static string html_ref (const string& url, const string& target) 
   {
      return string ("<A href=\"") + url + "\">" + target + "</A>";
   }



//////////////////////////////////////////////////////////////////////////
//                                                                      //
// xsilHandlerQueryFile                                                 //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
   class xsilHandlerQueryFile : public xml::xsilHandlerQuery {
   public:
      /// Constructor
      xsilHandlerQueryFile (const string& fname,
                        std::ostream& os)
      : fFilename (fname), fOs (os) {
      }
      /// returns a handler for the specified object (or 0 if not)
      virtual xml::xsilHandler* GetHandler (const attrlist& attr);
   
   protected:
      /// filename
      const std::string&	fFilename;
      /// stream
      std::ostream&		fOs;
   };

//______________________________________________________________________________
   xml::xsilHandler* xsilHandlerQueryFile::GetHandler (
                     const attrlist& attr) 
   {
      cerr << "Handler" << endl;
      attrlist::const_iterator ni = attr.find (xml::xmlName);
      if (ni != attr.end()) {
         fOs << html_ref (string ("/") + fFilename + "/" + ni->second,
                         ni->second) << "<BR>" << endl;
      }
      return xml::xsilParser::IgnoreAllHandler().GetHandler(attr);
   }


//////////////////////////////////////////////////////////////////////////
//                                                                      //
// xsilContainerHandler                                                 //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
   class xsilContainerHandler : public xml::xsilHandler {
   public:
      /// Constructor
      xsilContainerHandler (const string& fname,
                        const string& container,
                        std::ostream& os, const attrlist& attr);
      /// Destructor
      ~xsilContainerHandler();
      /// Output a paramter form
   template <class T>
      ostream& format (ostream& os, const std::string& name,
                      const std::string& tname,
                      const T& p, int N = 1);
      /// bool parameter callback (must return true if handled)
      virtual bool HandleParameter (const std::string& name,
                        const attrlist& attr,
                        const bool& p, int N = 1) {
         format (fOs, name, "boolean", p, N);
         return true; }
      /// byte parameter callback (must return true if handled)
      virtual bool HandleParameter (const std::string& name,
                        const attrlist& attr,
                        const char& p, int N = 1) {
         format (fOs, name, "byte", p, N);
         return true; }
      /// short parameter callback (must return true if handled)
      virtual bool HandleParameter (const std::string& name,
                        const attrlist& attr,
                        const short& p, int N = 1) {
         format (fOs, name, "short", p, N);
         return true; }
      /// int parameter callback (must return true if handled)
      virtual bool HandleParameter (const std::string& name,
                        const attrlist& attr,
                        const int& p, int N = 1) {
         format (fOs, name, "int", p, N);
         return true; }
      /// long parameter callback (must return true if handled)
      virtual bool HandleParameter (const std::string& name,
                        const attrlist& attr,
                        const long long& p, int N = 1) {
         format (fOs, name, "long", p, N);
         return true; }
      /// float parameter callback (must return true if handled)
      virtual bool HandleParameter (const std::string& name,
                        const attrlist& attr,
                        const float& p, int N = 1) {
         format (fOs, name, "float", p, N);
         return true; }
      /// double parameter callback (must return true if handled)
      virtual bool HandleParameter (const std::string& name,
                        const attrlist& attr,
                        const double& p, int N = 1) {
         format (fOs, name, "double", p, N);
         return true; }
      /// complex float parameter callback (must return true if handled)
      virtual bool HandleParameter (const std::string& name,
                        const attrlist& attr,
                        const std::complex<float>& p, int N = 1) {
         format (fOs, name, "fComplex", p, N);
         return true; }
      /// complex double parameter callback (must return true if handled)
      virtual bool HandleParameter (const std::string& name,
                        const attrlist& attr,
                        const std::complex<double>& p, int N = 1) {
         format (fOs, name, "dComplex", p, N);
         return true; }
      /// string parameter callback (must return true if handled)
      virtual bool HandleParameter (const std::string& name,
                        const attrlist& attr,
                        const std::string& p) {
         format (fOs, name, "string", p, 1);
         return true; }
   
      /// time callback (must return true if handled)
      virtual bool HandleTime (const std::string& name,
                        const attrlist& attr,
                        unsigned long sec, unsigned long nsec) {
         format (fOs, name, "time", Time (sec, nsec), 1);
         return true; }
   
   private:
      /// filename
      const std::string&	fFilename;
      /// container
      const std::string&	fContainer;
      /// stream
      std::ostream&		fOs;
   };

//______________________________________________________________________________
   xsilContainerHandler::xsilContainerHandler (const string& fname,
                     const string& container,
                     std::ostream& os, const attrlist& attr) 
   : xsilHandler (true), fFilename (fname), fContainer (container),
   fOs (os) 
   {
      string s = "Paramter";
      while (s.size() < 30) s += " ";
      s += "Type";
      while (s.size() < 40) s += " ";
      s += "Value";
      string::size_type pos;
      while ((pos = s.find (' ')) != string::npos) {
         s.replace (pos, 1, "&nbsp;"); 
      }
      fOs << "<tt>" << s << "</tt>" << endl;
      fOs << "<FORM ACTION=\"/" << fFilename << "/" <<
         fContainer << "\"" << " Method=\"POST\">" << endl;
      fOs << "<INPUT Name=\"Command\" Type=\"HIDDEN\" Value=\"change\">" 
         << endl;
   }

//______________________________________________________________________________
   xsilContainerHandler::~xsilContainerHandler() 
   {
      fOs << "<P><center>" <<
         "<INPUT Value=\"Change\" Type=\"SUBMIT\">" << endl;
      fOs << "</center></FORM>" << endl;
   }

//______________________________________________________________________________
template <class T>
   ostream& xsilContainerHandler::format (ostream& os, 
                     const std::string& name,
                     const std::string& tname,
                     const T& p, int N) 
   {
      string s = name;
      while (s.size() < 30) s += " ";
      s += tname;
      while (s.size() < 40) s += " ";
      string::size_type pos;
      while ((pos = s.find (' ')) != string::npos) {
         s.replace (pos, 1, "&nbsp;"); 
      }
      os << "<tt>" << s << "</tt>";
      if (N == 1) {
         os << "<INPUT Name=\""<< name << "\" Type=\"TEXT\" "
            << "Value=\"" << p << "\">" << endl;
      }
      else {
         for (int i = 0; i < N; ++i) {
            os << "<INPUT Name=\"" << name << "{" << i << "}\" Type=\"TEXT\" "
               << "Size=\"8\" Value=\"" << (&p)[i] << "\">" << endl;
         }
      }
      os << "<BR>";
      return os;
   }



//////////////////////////////////////////////////////////////////////////
//                                                                      //
// xsilHandlerQueryContainer                                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
   class xsilHandlerQueryContainer : public xml::xsilHandlerQuery {
   public:
      /// Constructor
      xsilHandlerQueryContainer (const string& fname,
                        const string& container,
                        std::ostream& os)
      : fFilename (fname), fContainer (container), fOs (os) {
      }
      /// returns a handler for the specified object (or 0 if not)
      virtual xml::xsilHandler* GetHandler (const attrlist& attr);
   
   protected:
      /// filename
      const std::string&	fFilename;
      /// container
      const std::string&	fContainer;
      /// stream
      std::ostream&		fOs;
   };

//______________________________________________________________________________
   xml::xsilHandler* xsilHandlerQueryContainer::GetHandler (
                     const attrlist& attr) 
   {
      attrlist::const_iterator ni = attr.find (xml::xmlName);
      if (ni != attr.end() && (ni->second == fContainer)) {
         return new xsilContainerHandler (fFilename, fContainer, 
                              fOs, attr);
      }
      else {
         return xml::xsilParser::IgnoreAllHandler().GetHandler(attr);
      }
   }


//////////////////////////////////////////////////////////////////////////
//                                                                      //
// xmlform_server                                                       //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
   bool xmlform_server::RequestGet (const request_t& request,
                     response_t& response)
   {
      cout << "received request for " << request.GetUrl() << endl;
      response.SetStatusLine ("HTTP/1.0 200 OK");
   
      // Add date field
      char buf[1024];
      time_t tSec = getUTC (Now());
      strftime (buf, sizeof (buf), "%a, %d %b %Y %X GMT", gmtime (&tSec));
      response.AddHeader ("Date", buf);
      tSec = getUTC (GetUpdateTime());
      strftime (buf, sizeof (buf), "%a, %d %b %Y %X GMT", gmtime (&tSec));
      response.AddHeader ("Last-Modified", buf);
      // Add no-chache field
      response.AddHeader ("Cache-Control", "no-cache");   
      // Add server field
      response.AddHeader ("Server", "XmlForm/1.0 (LIGO)");
   
      // Check URL for file/container object
      string url = request.GetUrl();
      string left = url;
      if (left.find ('/') == 0) {
         left.erase (0, 1);
      }
      string file_name;
      string::size_type pos = left.find ('/');
      if (pos != string::npos) {
         file_name = left.substr (0, pos);
         left.erase (0, pos + 1);
         file_name = demangle (file_name);
      }
      else {
         file_name = demangle (left);
         left = "";
      }
      string container_name;
      pos = left.find ('/');
      if (pos != string::npos) {
         container_name = left.substr (0, pos);
         left.erase (0, pos + 1);
         container_name = demangle (container_name);
      }
      else {
         container_name = demangle (left);
         left = "";
      }
   
      // :TODO: better top page
      if ((url == "/") || (url == "/index.html")) {
         UpdateListing();
         ostringstream resp;
         resp << html_header << endl;
         index (resp);
         resp << html_trailer << endl;
         int len = resp.str().size();
         response.Reserve (len);
         memcpy (response.GetData(), resp.str().c_str(), len);
         response.AddHeader ("Content-Type", "text/html");
      }
      
      // No robots!
      else if (url == "/robots.txt") {
         ostringstream resp;
         resp << "# go away" << endl;
         resp << "User-agent: *" << endl;
         resp << "Disallow: /" << endl;
         int len = resp.str().size();
         response.Reserve (len);
         memcpy (response.GetData(), resp.str().c_str(), len);
         response.AddHeader ("Content-Type", "text/plain");   
      }
      
      // Filename
      else if (!file_name.empty() && container_name.empty()) {
         ostringstream resp;
         resp << html_header << endl;
         form (resp, file_name);
         resp << html_trailer << endl;
         int len = resp.str().size();
         response.Reserve (len);
         memcpy (response.GetData(), resp.str().c_str(), len);
         response.AddHeader ("Content-Type", "text/html");
      }
      
      // Container
      else if (!file_name.empty() && !container_name.empty()) {
         ostringstream resp;
         resp << html_header << endl;
         form (resp, file_name, container_name);
         resp << html_trailer << endl;
         int len = resp.str().size();
         response.Reserve (len);
         memcpy (response.GetData(), resp.str().c_str(), len);
         response.AddHeader ("Content-Type", "text/html");
      }
      
      // page not found
      else {
         response.SetStatusLine ("HTTP/1.0 404 Not found");
      }
   
      // Set content length
      if (response.GetLength() > 0) {
         char buf[1024];
         sprintf (buf, "%i", response.GetLength());
         response.AddHeader ("Content-Length", buf);
      }
      return true; 
   }

//______________________________________________________________________________
   bool xmlform_server::RequestPost (const request_t& request,
                     response_t& response)
   {
      cout << "received request for " << request.GetUrl() << endl;
      cout << "post request is " << request.GetData() << endl;
      // Add date field
      char buf[1024];
      time_t tSec = getUTC (Now());
      strftime (buf, sizeof (buf), "%a, %d %b %Y %X GMT", gmtime (&tSec));
      response.AddHeader ("Date", buf);
      tSec = getUTC (GetUpdateTime());
      strftime (buf, sizeof (buf), "%a, %d %b %Y %X GMT", gmtime (&tSec));
      response.AddHeader ("Last-Modified", buf);
      // Add no-chache field
      response.AddHeader ("Cache-Control", "no-cache");   
      // Add server field
      response.AddHeader ("Server", "XmlForm/1.0 (LIGO)");
   
      // Check URL for file/container object
      string url = request.GetUrl();
      string left = url;
      if (left.find ('/') == 0) {
         left.erase (0, 1);
      }
      string file_name;
      string::size_type pos = left.find ('/');
      if (pos != string::npos) {
         file_name = left.substr (0, pos);
         left.erase (0, pos + 1);
         file_name = demangle (file_name);
      }
      else {
         file_name = demangle (left);
         left = "";
      }
      string container_name;
      pos = left.find ('/');
      if (pos != string::npos) {
         container_name = left.substr (0, pos);
         left.erase (0, pos + 1);
         container_name = demangle (container_name);
      }
      else {
         container_name = demangle (left);
         left = "";
      }
   
      // Filename
      if (!file_name.empty() && container_name.empty()) {
         // action
         post_list postmsg;
         parsePost (postmsg, request.GetData(), request.GetLength());
         string cmd = postmsg["Command"];
         postmsg.erase ("Command");
         string cntr = postmsg["Container"];
         postmsg.erase ("Container");
         // Add a new container
         if (strcasecmp (cmd.c_str(), "new") == 0) {
         
         }
         // Remove a container
         else if (strcasecmp (cmd.c_str(), "delete") == 0) {
         
         }
         // return page
         ostringstream resp;
         resp << html_header << endl;
         form (resp, file_name);
         if (!cmd.empty() && !cntr.empty()) {
            char buf[1024];
            time_t tSec = getUTC (Now());
            strftime (buf, sizeof (buf), "%a, %d %b %Y %X UTC", gmtime (&tSec));
            resp << "Last modified (" << cmd << "): " << buf << endl;
         }
         resp << html_trailer << endl;
         int len = resp.str().size();
         response.Reserve (len);
         memcpy (response.GetData(), resp.str().c_str(), len);
         response.AddHeader ("Content-Type", "text/html");
      }
      
      // Container
      else if (!file_name.empty() && !container_name.empty()) {
         // action
         post_list postmsg;
         parsePost (postmsg, request.GetData(), request.GetLength());
         string cmd = postmsg["Command"];
         postmsg.erase ("Command");
         if (strcasecmp (cmd.c_str(), "new") == 0) {
         }
         else if (strcasecmp (cmd.c_str(), "delete") == 0) {
         }
         else if (strcasecmp (cmd.c_str(), "change") == 0) {
         }
         // return page
         ostringstream resp;
         resp << html_header << endl;
         form (resp, file_name, container_name);
         if (!cmd.empty()) {
            char buf[1024];
            time_t tSec = getUTC (Now());
            strftime (buf, sizeof (buf), "%a, %d %b %Y %X UTC", gmtime (&tSec));
            resp << "Last modified (" << cmd << "): " << buf << endl;
         }
         resp << html_trailer << endl;
         int len = resp.str().size();
         response.Reserve (len);
         memcpy (response.GetData(), resp.str().c_str(), len);
         response.AddHeader ("Content-Type", "text/html");
      }
      
      // page not found
      else {
         response.SetStatusLine ("HTTP/1.0 404 Not found");
      }
   
      // Set content length
      if (response.GetLength() > 0) {
         char buf[1024];
         sprintf (buf, "%i", response.GetLength());
         response.AddHeader ("Content-Length", buf);
      }
      return true;
   }

//______________________________________________________________________________
   bool xmlform_server::UpdateListing()
   {
      // Check timestamp
      thread::semlock lockit (fMux);
      Time now = Now();
      if (now - fListingTime < Interval (LISTING_TIMEOUT)) {
         return true;
      }
      // Open directory
      fListing.clear();
      DIR* dir = ::opendir (fBaseDir.c_str());
      if (!dir) {
         return false;
      }
      // Loop through directory
//      dirent* dentry = (dirent*) new char [sizeof(dirent) + 
//         pathconf(fBaseDir.c_str(), _PC_NAME_MAX) + 1];
      dirent* entry = 0;
      for (entry = readdir (dir); entry; entry = readdir (dir)) {
//      while ((::readdir_r (dir, dentry, &entry) == 0) && entry) {
         string fname (entry->d_name);
         string::size_type pos = fname.rfind (fXmlExt);
         if ((pos == string::npos) || (pos != fname.size() - 3) || 
            (pos <= 2) || (fname[pos-1] != '.')) {
            continue; // not an XML file
         }
         fname.erase (pos - 1);
         fListing.insert (listing::value_type (fname, ""));
      }
//      delete [] (char*) dentry;
      ::closedir (dir);
      return true;
   }

//______________________________________________________________________________
   Time xmlform_server::GetUpdateTime() const 
   {
      thread::semlock lockit (fMux);
      return fListingTime;
   }

//______________________________________________________________________________
   bool xmlform_server::parsePost (post_list& prm, const char* p, int len)
   {
      if (!p || (len < 0)) {
         return false;
      }
      const char* start = p;
      while (*start) {
         const char* equal = start;
         while (*equal && (*equal != '=')) ++equal;
         const char* end = equal;
         while (*end && (*end != '&')) ++end;
         string s1 (start, equal - start);
         if (*equal) ++equal;
         string s2 (equal, end - equal);
         prm.insert (post_list::value_type (demangle (s1), demangle (s2)));
         start = end;
         if (*start) ++start;
      }
      return true;
   }

//______________________________________________________________________________
   bool xmlform_server::index (ostream& os)
   {
      os << "<h1>" << fTitle << "</h1>" << endl;
      os << "<h2>LIGO Laser Interferometer Gravitational-wave"
         " Observatory</h2>" << endl;
      os << "<h3>Index</h3>" << endl;
      os << "<PRE><HR>";
      for (listing::iterator i = fListing.begin(); i != fListing.end(); ++i) {
         os << html_ref (string ("/") + i->first, i->first) << endl;
      }
      os << "<HR></PRE>" << endl;
      return true;
   }

//______________________________________________________________________________
   bool xmlform_server::form (ostream& os, const string& filename)
   {
      os << "<h1>" << filename << "</h1>" << endl;
      os << "<HR>";
      xsilHandlerQueryFile fileQ (filename, os);
      xml::xsilParser parser;
      parser.AddHandler (fileQ);
      string fname = fBaseDir + "/" + filename;
      if (!fXmlExt.empty()) {
         fname += ".";
         fname += fXmlExt;
      }
      parser.ParseFile (fname.c_str());
      os << "<HR>" << endl;
      os << "<FORM ACTION=\"/" << filename << "\"" 
         << " Method=\"POST\">" << endl;
      os << "<INPUT Name=\"Command\" Type=\"HIDDEN\" Value=\"new\">" 
         << endl;
      os << "Container: " 
         << "<INPUT Name=\"Container\" Type=\"TEXT\">" << endl;
      os << " &nbsp; " << "<INPUT Value=\"New\" Type=\"SUBMIT\">" 
         << endl;
      os << "</FORM>" << endl;
      os << "<FORM ACTION=\"/" << filename << "\"" 
         << " Method=\"POST\">" << endl;
      os << "<INPUT Name=\"Command\" Type=\"HIDDEN\" Value=\"delete\">" 
         << endl;
      os << "Container: " 
         << "<INPUT Name=\"Container\" Type=\"TEXT\">" << endl;
      os << " &nbsp; " << "<INPUT Value=\"Delete\" Type=\"SUBMIT\">" 
         << endl;
      os << "</FORM><HR>" << endl;
      return true;
   }

//______________________________________________________________________________
   bool xmlform_server::form (ostream& os, const string& filename,
                     const string& container)
   {
      os << "<h1>" << filename << "</h1>" << endl;
      os << "<h2>" << container << "</h2>" << endl;
      os << "<HR>" << endl;
      xsilHandlerQueryContainer containerQ (filename, container, os);
      xml::xsilParser parser;
      parser.AddHandler (containerQ);
      string fname = fBaseDir + "/" + filename;
      if (!fXmlExt.empty()) {
         fname += ".";
         fname += fXmlExt;
      }
      parser.ParseFile (fname.c_str());
      os << "<HR>" << endl;
      os << "<FORM ACTION=\"/" << filename << "/" <<
         container << "\"" << " Method=\"POST\">" << endl;
      os << "<INPUT Name=\"Command\" Type=\"HIDDEN\" Value=\"new\">" 
         << endl;
      os << "Parameter: " <<
         "<INPUT Name=\"Parameter\" Type=\"TEXT\">" << endl;
      os << " &nbsp; Type: " << "<SELECT Name=\"Type\">" << endl;
      os << "<OPTION>string"<< endl;
      os << "<OPTION>int"<< endl;
      os << "<OPTION>double"<< endl;
      os << "<OPTION>time"<< endl;
      os << "<OPTION>complex double"<< endl;
      os << "<OPTION>bool"<< endl;
      os << "<OPTION>char"<< endl;
      os << "<OPTION>short"<< endl;
      os << "<OPTION>long"<< endl;
      os << "<OPTION>float"<< endl;
      os << "<OPTION>complex float"<< endl;
      os << "</SELECT>"<< endl;
      os << " &nbsp; Dimension: " <<
         "<INPUT Name=\"Dimension\" Type=\"TEXT\" Size=\"4\" " 
         << "Value=\"1\">" << endl;
      os << " &nbsp; " <<
         "<INPUT Value=\"New\" Type=\"SUBMIT\">" << endl;
      os << "</FORM>" << endl;
      os << "<FORM ACTION=\"/" << filename << "/" <<
         container << "\"" << " Method=\"POST\">" << endl;
      os << "<INPUT Name=\"Command\" Type=\"HIDDEN\" Value=\"delete\">" 
         << endl;
      os << "<INPUT Name=\"Container\" Type=\"HIDDEN\" Value=\""
         << filename << "\">" << endl;
      os << "Parameter: " <<
         "<INPUT Name=\"Parameter\" Type=\"TEXT\">" << endl;
      os << " &nbsp; " <<
         "<INPUT Value=\"Delete\" Type=\"SUBMIT\">" << endl;
      os << "</FORM><HR>" << endl;
      return true;
   }

}
