/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef TRIG_PROCESS_LIST_HH
#define TRIG_PROCESS_LIST_HH

#include "TrigProc.hh"
#include <vector>

namespace trig {

    class ProcTable;

    /**  The proclist class keeps a use-conted list of processes for the
      *  segment and trigger table classes.
      *  \brief Process list class.
      *  \author John Zweizig
      *  \version 1.0; last modified February 12, 2009
      */
    class ProcList {
    public:
	typedef unsigned long count_type;
    public:
	ProcList(void);
	~ProcList(void);
	TrigProc& insert(const TrigProc& p);
	bool unuse(const std::string& pid);
	void put(ProcTable& ptab) const;
    private:
	struct list_entry {
	    list_entry(const TrigProc& p);
	    TrigProc   _proc;
	    count_type _use;
	};
	typedef std::vector<list_entry>   proc_vect;
	typedef proc_vect::iterator       proc_iter;
	typedef proc_vect::const_iterator const_proc_iter;

	proc_vect mProcVect;
    };

    //==================================  list_entry inline functions
    inline 
    ProcList::list_entry::list_entry(const TrigProc& p)
	: _proc(p), _use(1)
    {}

}  // namespace trig;

#endif // !defined(TRIG_PROCESS_LIST_HH)
