/* -*- mode: c++; c-basic-offset: 4; -*- */
#include <time.h>
#include "NameClient.hh"
#include <lmsg/ErrorList.hh>
#include <cstring>
#include <cstdlib>
#include <cstdio>
#include <iostream>

using namespace lmsg;
using namespace std;

static void
syntax(const string& msg) {
    if (!msg.empty()) cerr << "Error in command line: " << msg << endl;
    cerr << "Command syntax: " << endl;
    cerr << "NameCtrl <sub-cmd> [-a <address>] [-p <port>] [-t <type>] [<name>]"
	 << endl;
    cerr << "sub-commands:" << endl;
    cerr << "add     Add a name to the dictionary" << endl;
    cerr << "index   Print all known names" << endl;
    cerr << "list    Print a specified name entry" << endl;
    cerr << "remove  Remove name from the dictionary" << endl;
}

int 
main(int argc, const char** argv) {

    //----------------------------------  Parse the command line.
    if (argc < 2) {
	syntax("Command not specified");
	return 1;
    }
    string cmd = argv[1];
    if (cmd == "--help") {
	syntax("");
	return 0;
    }
    if (cmd != "add" && cmd != "remove" && cmd != "list" && cmd != "index") {
	syntax("Invalid command name");
	return 2;
    }

    MsgAddr addr;
    NameProcs pType = p_Any;
    int ident(-1), debug(0);
    for (int i=2; i<argc-1; i++) {
	string argi = argv[i];
        if (argi == "-a") {
	    addr = MsgAddr::findIPHost(argv[++i]);
	} 
	else if (argi == "-debug") {
	    debug = strtol(argv[++i], 0, 0);
	} 
	else if (argi == "-id") {
	    ident = strtol(argv[++i], 0, 0);
	} 
	else if (argi == "-p") {
	    addr.setIPPort(strtol(argv[++i], 0, 0));
	} 
	else if (argi == "-t") {
	    pType = static_cast<NameProcs>(strtol(argv[++i], 0, 0));
	} 
	else if (i != argc-1) {
	    syntax(string("Invalid argument: ") + argi);
	    return 3;
	}
    }
    string name = argv[argc-1];

    //-----------------------------------  Construct a name client.
    NameClient nc;
    nc.setDebug(debug);
    int rc=0;

    //----------------------------------  Add a name
    if (cmd == "add") {
	rc = nc.addName(name.c_str(), addr, pType);
    }

    //----------------------------------  Print an index
    if (cmd == "index") {
	string Index;
	rc = nc.getIndex(Index, addr.getIPAddr(), pType);
	if (!rc) cout << Index << endl;
    }

    //----------------------------------  Display a name entry
    if (cmd == "list") {
	NameData   NamEnt;
	if (ident < 0) rc = nc.lookup(name.c_str(),    NamEnt);
	else           rc = nc.lookupID(ident, NamEnt);
        if (!rc) {
	    cout << "Address entry for " << name << ":" << endl;
	    cout << "Name:    " << NamEnt.getName()  << endl;
	    cout << "Type:    " << NamEnt.getPType() << endl;
	    cout << "Address: " << NamEnt.getAddr()  << endl;
	}
    }

    //----------------------------------  Remove a name
    else if (cmd == "remove") {
	rc = nc.remName(name.c_str());
    }

    switch(rc) {
    case OK:
	break;
    case BadAddress:
    case TimeOut:
	cerr << "Unable to reach name server at: " << nc.getDomain() 
	     << endl;
	break;
    case Invalid:
    case Failure:
	if (ident < 0) cerr << "Server name: " << argv[argc-1] 
			    << " is not registered." << endl;
	else           cerr << "Server ID: " << ident
			    << " does not exist." << endl;
	break;
    case SystemError:
	perror("System Error");
	break;
    default:
	cerr << "Unexpected error: " << rc << endl;
    }
    return rc;
}
