#include "suspensionMon.hh"
#include "susConstructs.hh"
#include "ParseLine.hh"

#include <iostream>
#include <cstdlib>
#include <cmath>
#include <cstring>
#include <iomanip>
#include <string>
#include <cstring>
#include <vector>
#include "xml/XsilHistogram.hh"
#include <time.h>
#include <cstdio>
#include <sys/types.h>


using namespace std;
using namespace channel;
using namespace xml;

EXECDAT(suspensionMon);
   
  
// constructor
suspensionMon::suspensionMon(int argc, const char *argv[]) :
  DatEnv(argc,argv), MonServer("suspensionMon"), mOSC(getDacc()),
  dataLoopNum(0), fCurrentTime(0), fLogStartTime(0), fLogInit(false),
  fDataInit(false) {
  if ( Debug() > 1 ) cout << "Starting suspensionMon..."<<endl;
  //bool usetoc=true;
  const char *confpath = getenv("DMTPARS");
  string cfile, oscfile;
  if (confpath) {
    cfile   = (string)confpath + "/suspensionMon.conf";
    oscfile = (string)confpath + "/LockLoss.conf";
  } else {
    cfile   = "./suspensionMon.conf";
    oscfile = "./suspensionMon_osc.conf";
  }

  Reset();
  
  //=======================  Parse command line arguments
  for (int i=1; i<argc; i++) {
    
    if (!strcmp("-conf", argv[i])) {
      if (chkNextArg(i,argv,argc)) cfile = argv[++i];
      else {
	cerr << "Couldn't find configuration file"<<endl;
	exit(Usage(argv[0])+1);
      }
    } else if (!strcmp("-osc", argv[i])) {
      if (chkNextArg(i,argv,argc)) oscfile = argv[++i];
      else {
	cerr << "Couldn't find OSC file"<<endl;
	exit(Usage(argv[0])+1);
      }
    } else if (!strcmp("-h",argv[i])|| !strcmp("--help",argv[i])) {
      exit(Usage(argv[0]) - Help());
    //} else if (!strcmp("-toc",argv[i])) {
    //usetoc=false;
    //} else if (!strcmp("+toc",argv[i])) {
    } else if (!strcmp("-v", argv[i]) || !strcmp("--version",argv[i])) {
      cout <<PIDCVSHDR<<endl;
      exit(0);
    }else if (isDatEnvArg(argv[i])) i++;
    else exit(Usage(argv[0]));
  }
  //getDacc().setTOCMode(usetoc);  // Determines whether we'll use frame toc's

  //=======================  Define and initialize parameters
  mDict.addPar("Data_File_Prefix",  std::string("suspensionMon_data"));
  mDict.addPar("Log_File_Prefix",   std::string("suspensionMon_log"));
  mDict.addPar("Number_Bins",       std::string("20"));
  mDict.addPar("Loop_Time",         std::string("60"));
  mDict.addPar("Total_Runtime",     std::string("0"));
  mDict.addPar("Trigger_ON/OFF",    std::string("1"));
  mDict.addPar("Trend_One_Prefix",  std::string());
  mDict.addPar("Trend_Two_Prefix",  std::string());
  
  //=======================  Enroll with Trigger Manager
  mTrig.enroll();

  //=======================  open & read config file
  ifstream testinput(oscfile.c_str());
  if (testinput) { testinput.close(); mOSC.readConfig(oscfile); }
  ReadConfig(cfile);

  //=======================  start the log file
  //OutputLog(true);

    // append initial UTC date to the filename & prepend appropriate path
    string fLogName = fLogPath;
    char *outSuffix= new char[12];
    fLogName += (string) TimeStr(fInitTime,outSuffix,".%y.%02m.%02d");
    delete[] outSuffix;
    if (fLogName[0] != '/' && fLogName[0] != '.') {
      const char* htmldir = getenv("DMTHTMLOUT");
      if (htmldir) fLogName = string(htmldir) + "/" + fLogName;
    }
    fLogFile.open(fLogName.c_str(),ios::out|ios::app);
    if (!fLogFile.is_open()){
      cerr<<"Log File Error: "<<fLogName<<endl;
      finish();
      return;
    }
   
  //-----------  Output configuration
    fLogFile << "#====================================" << endl
	     << "# file path to the text output data file" << endl
	     << "Data_File_Prefix : " << fDataPath << endl << endl
	     << "# file path to the log file" << endl
	     << "Log_File_Prefix  : " << fLogPath << endl << endl
	     << "# length of data to process in seconds (0 for infinity)"<<endl
	     << "Total_Runtime    : " << fEndRuntime << endl << endl
	     << "# of bins which composes each histogram" << endl
	     << "Number_Bins      : " << fBinNumber << endl << endl
	     << "# overall allows/disallows triggers to be sent"<<endl
	     << "Trigger_ON/OFF   : " << fTriggerON << endl << endl;
//      for ( CHiter i = fChannels.begin(); i != fChannels.end(); ++i ) {
//        fLogFile<<"Channel "<<i->getName()<<' '      <<i->fDeadTime<<' '
//  	      <<i->fUseOSC<<' '    	       <<i->fRMS<<' '
//  	      <<i->fThreshold<<' ';
//        fLogFile<<i->DumpPoles(fLogFile)<<" ";
//        fLogFile<<i->DumpZeroes(fLogFile)<<" ";
//        fLogFile<<i->fTrigComment<<endl;
//      }
//    //-----------  output starting time
//      if ( fLogStartTime == Time(0) ) { // output absGlitch start time
//        fLogStartTime = fCurrentTime;
//        fLogFile << "###===================================="      << endl
//  	       << "### Monitor Start = " << fLogStartTime.getS() << endl
//  	       << "###------------------------------------"      << endl;
//    //-----------  set histogram time stamps
//        for ( CHiter ch = fChannels.begin(); ch != fChannels.end(); ch++ ) {
//  	ch->fHist.SetTime(fCurrentTime);
//  	ch->fHistAll.SetTime(fCurrentTime);
//  	ch->fTimeHist.SetTime(fCurrentTime);
//  	ch->fTimeHistAll.SetTime(fCurrentTime);
//  	ch->fShortHist.SetTime(fCurrentTime);
//        }
//      } // if ( !fLogStartTime.getS() )
//      fLogCount = 0;
//      fLogInit = true;

    //======================= Kluge for setting the logfile output to fLogFile

    for (CHiter ch=fChannels.begin(); ch!=fChannels.end(); ch++) {
      ch->refResult("runOutput-log")->setOutput(&fLogFile);
      if (Debug() > 1) cout << "setting output" << endl;
    }

    //  trendOne.open();
    //    trendTwo.open();
}


// destructor
suspensionMon::~suspensionMon(void) {
  if ( Debug() > 1) cout << "Closing suspensionMon..." << endl;
  TSeries dummyTS;
  if ( Debug() > 1) cout << "Closing suspensionMon debug two" << endl;
  for (CHiter ch = fChannels.begin(); ch != fChannels.end(); ch++) {
    if ( Debug() > 1) cout << "Closing suspensionMon debug three" << endl;
    ch->dumpStats(cout);
  }

  // trendOne.close();
  // trendTwo.close();
     
}

void suspensionMon::ReadConfig(const string& config) {
  if (Debug() > 1) cout <<"Reached ReadConfig(void)"<<endl;
  //=======================  Set up the line parser
  ParseLine lp(config.c_str());
  if (Debug()) lp.setLog(cout);
  unsigned int nLine(0);
  string commonOSC("");		//contains the common base string for OSC
     
  //=======================  read and set configurations
  for (int nArg=lp.getLine(); nArg>=0; nArg=lp.getLine()) {
    nLine++;
  //-----------  Empty command line
    if (!lp[0]) {
      continue;
  //-----------  Parse parameters (second arg is ':')
    } else if ( !strcmp(lp[1],":") ) {
      if (!mDict.exists(lp[0])) {
	cerr<<"No such parameter: "<<lp[0]<<endl;
	continue;
      } else {
	if (Debug()) cout<<"Set parameter: "<<lp[0]<<" = "<<lp[nArg - 1]<<endl;
	mDict.setPar(lp[0], lp[nArg - 1]);
      }
  //-----------  Parse channels
    } else if ( !strcmp(lp[0], "Channel") ) {
      // fChannels.push_back( chInterface(lp[1], lp[2], Debug()) );
      fChannels.push_back( chInterface(lp[1], lp[2], &(getDacc()), Debug()) );
      if (Debug() > 1) cout <<"Setting Name "<<lp[1]<<" and OSC "<<lp[2]<<endl;
      //------- figure out the common OSC requests
      string osc(lp[2]);
      if (osc.size() > 1) {
	if (commonOSC.empty()) commonOSC = osc;
	else commonOSC = getCommonString(commonOSC,osc);
      }

      //------- add a filter if poles and zeroes present
      if (nArg > 3) {
	if (Debug() > 2) cout <<"Filter poles and zeroes present..."<<endl;
	if (nArg > 6) {		// check if a non-unity gain is present
	  if (Debug() > 2) cout <<"Adding a gain: "<<atof(lp[5])<<endl;
	  fChannels.back().addFilter( string(lp[6]),lp[3],lp[4],atof(lp[5]) );
	} else
	  fChannels.back().addFilter( string(lp[5]),lp[3],lp[4] );
      }
      // getDacc().addChannel( fChannels.back().getName().c_str(), 0,
      // fChannels.back().getData() );
  //-----------  Parse filters for channel
    } else if ( !strcmp(lp[0], "Filter") ) {
      if (nArg == 4) fChannels.back().addFilter( string(lp[1]),lp[2],lp[3] );
      else if (nArg == 5) {	// check if the last arg is a number or string
	if (strcspn(lp[5],"0123456789."))
	  fChannels.back().addFilter( string(lp[1]),lp[2],lp[3],
				      1.0, string(lp[4]));
	else
	  fChannels.back().addFilter( string(lp[1]),lp[2],lp[3],atof(lp[4]) );
      } else if (nArg == 6)
	fChannels.back().addFilter( string(lp[1]),lp[2],lp[3],
				    atof(lp[4]), string(lp[5]) );
      else { cout <<"Can't parse filter "<<lp[1]<<endl; continue;}
      if (Debug() > 1) cout <<"Adding filter "<<lp[1]<<endl;
  //-----------  Parse glitch definitions for channel
    } else if ( !strcmp(lp[0], "Glitch") ) {
      if (nArg < 4) {cout <<"Can't parse glitch "<<lp[1]<<endl; continue;}
      fChannels.back().addGlitch(string(lp[1]));
      glitchList.push_back(lp[1]);
      fChannels.back().refGlitch(lp[1])->setThreshold(atof(lp[2]));
      fChannels.back().refGlitch(lp[1])->setWaitTime(atof(lp[3]));
      if (Debug() > 1) cout <<"Adding glitch "<<lp[1]<<endl;
  //-----------  Parse statistic definitions for channel
    } else if ( !strcmp(lp[0], "Statistic") ) {
      bool parsable=true;	// indicates parsability of entry
      string stType("");	// Type of statistic ("Mean","RMS","Kurt","susStatistic")
      double stInit(0.0);
      int    stShort(0),stLong(0);
      switch (nArg) {
      case 6: stInit = atof(lp[5]);
      case 5: 
	stType  = lp[2];
	stShort = atoi(lp[3]);
	stLong  = atoi(lp[4]);
	break;
      case 4: 
      case 3:
      case 2:
      case 1:
      default: parsable=false;
      }
      //-------  Check for parsability
      if (!parsable) {cout <<"Can't parse statistic "<<lp[1]<<endl; continue;}
      //-------  Everything should be okay now, let's add the stats
      //-------  Right now, everything is just going to be the default stat
      //-------  In the (near!) future we'll check which stat to add
      if (!(strcmp(lp[2], "susStatistic"))){
         susStatistic mystat(lp[1], uContinuous, 0.0, stLong, stShort, stInit,
			     Debug());
         fChannels.back().addStatistic(lp[1], mystat);
	 if (Debug() > 1) cout << "susStatistic debugged" <<endl;}
      else
	fChannels.back().addStatistic(string(lp[1]),1);
      statList.push_back(lp[1]);
      //-------  We'll even throw in an initial value
      if (stInit) {
	if (Debug() > 1) cout <<"  Setting initial value = "<<stInit<<endl;
	fChannels.back().refStats(lp[1])->setInitialValue(stInit);
      }
      if (Debug() > 1) cout <<"Adding statistic "<<lp[1]<<endl;
  //-----------  Parse result definitions for channel
    } else if ( !strcmp(lp[0], "Result") ) {
      bool parsable=true;	// indicates parsability of entry
      updateType kont=uUnknown; // indicates continuous / refreshed result type
      //bool kont=true;		// indicates cumulative / updated
      //      string rtType("");	// Type of result ("Mean","RMS","Kurt")
      int tmpV  =0;		// Temp "Five", where lp[5] gets put
      int tmpIV =0;		// Temp "Four", where lp[4] gets put
      string outfile1("");	// Prefix of data/log file 1
      string outfile2("");	// Prefix of data/log file 2
      string eventname = (string)lp[1];

      switch (nArg) {
      case 8: outfile2=lp[7];
      case 7: outfile1=lp[6];
      case 6:
	if (!atoi(lp[2])) tmpV =atoi(lp[5]);
	else {
	  if (outfile2.empty()) outfile2=outfile1;
	  outfile1=lp[5];
	}
      case 5: tmpIV=atoi(lp[4]);
	//rtType=lp[2];
	if (Debug() > 1) cout<<"lp[3] = "<<atoi(lp[3])<<endl;
	switch(atoi(lp[3])) {
	case 1:
	  kont = uContinuous;
	  break;
	case 0:
	  kont = uRefreshed;
	  break;
	default:
	  cout<<"Can't identify update type for result "<<eventname<<endl;
	}
	//-----  Ideally, tmpIV is an Interval, and tmpV is an output mask
	if ((kont == uContinuous) && (tmpIV <= 0)) { parsable=false; break;}
	else if (kont == uContinuous) tmpV=tmpIV; // output mask of '0' means no output
	else if ((kont == uRefreshed) && !tmpIV) tmpIV=3600;
	break;
      case 4:
      case 3:
      case 2:
      case 1:
      default: parsable=false;
      }

      //-------  Check for parsability  
      if (!parsable) {cout <<"Can't parse result "<<eventname<<endl; continue;}
      //-------  Everything should be okay now, let's add the result
      if (!(strcmp(lp[2], "susLog"))){
         susLog mylog(eventname, kont, (unsigned int)tmpV, cout, double(tmpIV), Debug());
	 //how do we set output mask?
         fChannels.back().addResult(eventname, mylog);
	 if (Debug() > 1) cout << "susLog debugged" <<endl;}
      else if (!(strcmp(lp[2], "susEvent"))){
	// determine if susEvent, to get thresholds read next line
	lp.getLine();
	if (Debug() > 1) cout << "lp[0] = "<< lp[0] << " lp[1] = " << lp[1] <<endl;
	double	stThresh =atof( lp[0]);
	double	ltThresh =atof( lp[1]); 
	 if (Debug() > 1) cout << "thresholds added" <<endl; 
         susEvent myEvent(eventname, kont, (unsigned int)tmpV, cout, double(tmpIV), Debug(), stThresh, ltThresh);
	 //how do we set output mask?
         fChannels.back().addResult(eventname, myEvent);
	 if (susEvent* pEvent = dynamic_cast<susEvent*>(fChannels.back().refResult(eventname))){
	     pEvent->setOSC( mOSC , fChannels.back().getOSC());
	     if (atoi(mDict.getString("Trigger_ON/OFF").c_str()))
	       pEvent->setTrig(mTrig);
	 }
	 else  cout << "not a susEvent" << endl;
	 if (Debug() > 1) cout << "susEvent debugged" <<endl;}
      else
	fChannels.back().addResult(string(eventname),true);
      resultList.push_back(eventname);      
      //-------  Now we're just getting fancy
      if ((fChannels.back().refResult(eventname)->getType() == uContinuous) && (Debug() > 1))
	cout <<"  Result "<<eventname<<" is cumulative."<<endl;
      else if (fChannels.back().refResult(eventname)->getType() == uRefreshed) {
	if (Debug() > 1) cout<<"  Result "<<eventname<<" is refreshable."<<endl;
	if (Debug() > 1) cout <<"  Setting refresh rate = "<<tmpIV<<" seconds"<<endl;
	fChannels.back().refResult(eventname)->setUpdate(tmpIV);
      } else {
	if (Debug() > 1) cout<<"  Result "<<eventname<<" has unknown update type."<<endl;
      }
      //-------  We'll even throw in some log & data files
      if (Debug()) {
	if (!tmpV)    cerr <<"  Result "<<eventname<<" has no output!!!"<<endl;
	if (tmpV & 1) cout <<"  Result "<<eventname<<" sends output to cout"<<endl;
	if (tmpV & 2) cout <<"  Result "<<eventname<<" outputs to datafile"<<endl;
	if (tmpV & 4) cout <<"  Result "<<eventname<<" outputs to logfile"<<endl;
	if (tmpV & 8) cout <<"  Result "<<eventname<<" sends triggers"<<endl;
	if (tmpV & 16) cout <<"  Result "<<eventname<<" serves data"<<endl;
	if (tmpV & 32) cout <<"  Result "<<eventname<<" writes trendfiles"<<endl;
      }
      mOutMap[string(eventname)] = (unsigned int)tmpV;
      if (Debug() > 1) cout <<"Adding result "<< eventname <<endl;
  //-----------  Unable to parse line 
    } else {
      cerr << "Unable to parse configuration file.\nLine "<<nLine<<": ";
      for (int i=0; i < nArg; i++) cerr <<lp[i]<<" ";
      cerr << endl;
      continue;
    }
  }

  //=======================  Set up member elements
  fBinNumber        = atoi(mDict.getString("Number_Bins").c_str());
  fTriggerON        = atoi(mDict.getString("Trigger_ON/OFF").c_str());
  fEndRuntime       = atoi(mDict.getString("Total_Runtime").c_str());
  fLogInterval      = atof(mDict.getString("Log_Interval").c_str());
  fLogPath          = mDict.getString("Log_File_Prefix");
  fDataPath         = mDict.getString("Data_File_Prefix");

  if(Debug()>1) cout << "Before Trend Assignment" << endl;
  if(!mDict.getString("Trend_One_Prefix").empty()){
    if(Debug()>1) cout << "Inside Trend Assignment" << endl;
    trendOne.setName(mDict.getString("Trend_One_Prefix").c_str());
    trendOne.setType(Trend::kMinute);
    //    trendOne.setIFO(mDict.getString("Trend_One_Prefix").substr(0,2).c_str());
    trendOne.setIFO(fChannels.front().getName().substr(0,1).c_str());
    trendOne.setAutoUpdate(false);
    trendOne.setFrameCount(1);
    //    trendOne.setFrameLen(60);


    for (CHiter ch = fChannels.begin(); ch != fChannels.end(); ++ch) {
      /*      //get IFO prefixes
      string trendPre = mDict.getString("Trend_One_Prefix").substr(0,2);
      string ifoPre   = ch->getName().substr(0,2);
      //compare IFO with Trend IFO
      if(trendPre == ifoPre){ */
	susLog* trendy = dynamic_cast<susLog*>(ch->refResult("runOutput-log"));
	if (trendy){
	  //	  string tempstring = ch->getName() + "_longrms";
	  //	  trendOne.addChannel(tempstring.c_str());
	  //	  tempstring = ch->getName() + "_shortrms";
	  //	  trendOne.addChannel(tempstring.c_str());
	  trendy->setTrend(&trendOne);
	}
	//      }
    }
   
    //    trendOne.writeIndex();

  }


  // For time now (4-12-04) we'll comment out trend two since we may not need it
  /*
  if(!mDict.getString("Trend_Two_Prefix").empty()){
    trendTwo.setName(mDict.getString("Trend_Two_Prefix").c_str());
    trendTwo.setType(Trend::kMinute);
    trendTwo.setIFO(mDict.getString("Trend_Two_Prefix").substr(0,2).c_str());
    trendTwo.setAutoUpdate(false);
    trendTwo.setFrameCount(1);
    trendTwo.setFrameLen(60);
    trendTwo.writeIndex();
    for (CHiter ch = fChannels.begin(); ch != fChannels.end(); ++ch) {
      //get IFO prefixes
      string trendPre = mDict.getString("Trend_Two_Prefix").substr(0,2).c_str();
      string ifoPre   = ch->getName().substr(0,2).c_str();
      //compare IFO with Trend IFO
      if(trendPre == ifoPre){

	susLog* trendy = dynamic_cast<susLog*>(ch->refResult("runOutput-log"));	
	if (trendy){
	  string tempstring = ch->getName() + "_longrms";
	  trendTwo.addChannel(tempstring.c_str());
	  tempstring = ch->getName() + "_shortrms";
	  trendTwo.addChannel(tempstring.c_str());
	  trendy->setTrend(&trendTwo);
	}
      }
      
    }

    trendTwo.writeIndex();
  }
  */

  getDacc().setStride(atof(mDict.getString("Loop_Time").c_str()));

  // debug whether there's anything to analyze or not
  if (fChannels.empty()) {
    cerr << "No channels to analyze." << endl;
    finish();
    return;
  }

  // ignore any unused OSC parameters
  if (!commonOSC.empty()) mOSC.ignoreAllExcept(commonOSC);

  
  getDacc().synch();
  if ( Debug() > 1)  cout << "getDacc debug #1" << endl;
     getDacc().fillData(Interval(1.0),0);
  
  
  // For each chInterface, we'll grab the proper sampling rate and initialize
   for (CHiter i = fChannels.begin(); i != fChannels.end(); ++i) {
    if ( Debug() > 1) cout << "getDacc debug #2" << endl;
    /*          if ( getDacc().isChannelRead(i->getName().c_str()) ) {
      const TSeries ts=*getDacc().refData(i->getName().c_str());
      i->setSampleRate(ts.getNSample());
      
      bool init = i->Init(ts);
      if ( !init && Debug()) {
	cout <<"chInterface "<<i->getName()<<" is not initialized."<<endl;
      }// else if (!init) finish();

      if ( Debug() > 1 )
	cout << "Some Channel info: (name)" << i->getName()
	     <<" (rate)"<< ts.getNSample()<<" (osc condition)"<<i->getOSC()
	     <<" (# filters)" << i->FBank.size()<<endl;
    } // if ( getDacc().isChannelRead(i->fName.c_str()) )
    else cerr << "Channel " << i->getName() << " not found." << endl;
    } // for (CHiter i = fChannels.begin(); i != fChannels.end(); ++i)*/ 
  
    int init = i->Init();
     if (!init && Debug()) {
 cout <<"chInterface "<<i->getName()<<" is not initialized."<<endl;
       } else if (!init) finish();
     if ( Debug() > 1 )
       cout << "Some Channel info: (name)" << i->getName()
    <<" (rate)"<< (*i->getData())->getNSample()<<" (osc condition)"
    <<i->getOSC()<<" (# filters)" << i->FBank.size()<<endl;
   } // for (CHiter i = fChannels.begin(); i != fChannels.end(); ++i)

    if ( Debug() > 1) cout << "getDacc debug #3" << endl;

  // debug whether we've hooked up with data stream or not
  fLogStartTime = fCurrentTime = fInitTime = getDacc().getCurrentTime();
  if ( fCurrentTime == Time(0) ) cerr << "Couldn't find current time." <<endl;
  else if (Debug() > 1)
    cout <<"Starting suspensionMon time..."<<fCurrentTime.getS()<<endl;
}


// main loop
void suspensionMon::ProcessData(void) {
  if ( Debug() > 1) cout << "Starting ProcessData loop..." << endl;
  int t1=time(NULL);
  fCurrentTime = getDacc().getCurrentTime();
  double  elapsedTime;
  elapsedTime = (fCurrentTime-fLogStartTime);
  if (Debug())  cout << "elapsed time is " << elapsedTime << endl;
  if (((int)elapsedTime % 1000) < 60) fLogFile  << "  date     time    gpstime      longDev     shortDev      channel/filter name" << endl;

  if ( Debug() > 1 ) cout <<"Processing Data: "<<fCurrentTime.getS()<<endl;
  //=======================  If data is continuous, update stats & check event
  if ( fChannels.begin()->isTSContinuous() ) { // check continuity
    for (CHiter ch = fChannels.begin(); ch != fChannels.end(); ch++) {
      //----------- If the OSC, if used, is satisfied...
      //           if ( ch->getOSC().empty() || mOSC.satisfied(ch->getOSC().c_str()) ) {
	//--------- convert TSeries to double (note: should take 0 time, but
	//---------  we'll be safe (if slow) by doing it here.  Note that
	//---------  the reason we need this is IIRFilter only uses doubles
	(*ch->getData())->Convert(DVector::t_double);
	//--------- filter data
	ch->applyFilters();
        const list<statResult> *susOut(ch->applyStats( ));
	

	  if (Debug() > 1) cout << " looping through results #1" << endl;
	for (list<statResult>::const_iterator i= susOut->begin(); i != susOut->end(); i++) {
	  if (Debug() > 1) cout << " looping through results #2" << endl;
	  //	  if (i->comment.find("raw") == i->comment.npos){

	    if (Debug() > 1)
	      cout << "runOutput-log address:" << ch->refResult("runOutput-log") << endl;
	    ResultConstruct*  tmpResult = ch->refResult("runOutput-log");
	    //	    if(&tmpResult) tmpResult->output( *i, 4, false, fLogFile);
	    if(tmpResult) tmpResult->output(*i);
	    if (Debug() > 1)
	      cout << "trigger-log address: " << ch->refResult("trigger-log") << endl;
	    tmpResult = ch->refResult("trigger-log");
	    //	    if(&tmpResult) tmpResult->output( *i, 0, false);
	    if(tmpResult) tmpResult->output(*i);
	    //	  }

	}
	if (Debug() > 1) cout << "Writing Results" << endl;


	//for (unsigned int i=0; i < ch->FBank.size(); i++) {
	//--------- update the filtered data statistics
      
	// ch->applyStats( );
	//--------- check for event
	  //for (j=glitchList.begin(); j != glitchList.end(); j++) 
	  //   ch->applyGlitch( *j, ch->FBank[i] );
	//	}
	//      } // if ( ch->getOSC().empty() || mOSC.satisfied...
    } // for (CHiter ch = fChannels.begin(); ...


    if (!trendOne.getName().empty()){
      if (Debug() > 1) cout << "Inside Trend Bracket dataLoopNum = " << dataLoopNum  << endl;
      if (!dataLoopNum) {
	//	if (Debug() > 1) cout << "Opening Trend" << endl;
	//	trendOne.open();
	if (Debug() > 1) cout << "Writing Trend Index" << endl;
	trendOne.writeIndex();
	dataLoopNum++;
	if(Debug() >1) cout << "dataLoopNum increased to: " << dataLoopNum << endl;
      }

      if (Debug() > 1) cout << "Updating trendOne" << endl;
      // added a time in update parenthesis
      trendOne.Update();

      }

    //    trendTwo.Update();
    //    if (Debug() > 1) cout << "Updating trendTwo" << endl;

  //=======================  Otherwise there's a continuity error
  } // if (fChannels.begin()->IsTSContinuous())
  else fLogFile<<"TimeSeries Continuity Error "
	       <<(*fChannels.front().getData())->getStartTime().getS()<<endl;


  //=======================  Output stats, if need be
  //  OutputLog(true);
  
  //=======================  Check if we've reached the end of the run
  fCount++; // increment # of ProcessData executed
  if (fEndRuntime) {
    if (fCount >= fEndRuntime) finish();
  }

  if (Debug()>2) cout << "ProcessData loop executed in "
		    << double(fCurrentTime - getDacc().getCurrentTime())
		    << " seconds" << endl;
  int t2=time(NULL);
  if (Debug()>1) cout << "Time to ProcessData= " << t2-t1 << endl;
}

//  // data holds filtered time series
//  void suspensionMon::CheckEvent( chInterface *ch ) {
//    // reject channel with rms less than 1 count (saturated)
//    if (ch->fRMS > 1) {
//      for (int j=0; j < ch->fSampleFreq; j++) {
//        Time bintime = ch->fTSnew->getBinT(j);
//        const double datapt = ch->fTSnew->getDouble(j);
      
//        //------- Check whether datapt ends an event
//        if (CheckEvent(datapt,bintime,ch) ) OutputEvent(ch);
//      }
//    }
//  }

//  // Check if we're starting, ending, or in the middle of an event.  Return
//  //  true only if we've just ended an event.
//  bool suspensionMon::CheckEvent( const double& data, const Time& bintime,
//  			    chInterface *ch) {
//      //=====================  Data above threshold
//      if ( abs(data) > ch->fThreshold ) {
//        //--------- Special case: 0 dead time to histogram datapts
//        if ( !(ch->fDeadTime) ) {
//  	ch->fEventMax = abs(data);
//  	ch->fStartTime = bintime;
//  	ch->fEndTime = bintime + double(1)/(ch->fSampleFreq);
//  	return true;
//        }
//        //--------- Case 1: Start of event
//        if (ch->fEventStatus == chInterface::kNone) ch->StartEvent(bintime,data);
//        //--------- Case 2: Event continues
//        else ch->ContinueEvent(bintime,data);
//        if( Debug() > 2 ) cout <<"Offending datapt at GPS:"
//  			     <<setprecision(15)<<bintime.totalS()<<"\t"<<data
//  			     <<endl;
//        return false;
//        //=====================  Data below threshold    
//      } else { 
//        //--------- Case 1: Still in Event, or still Waiting
//        if ( ch->WaitingEvent(bintime, data) ) {
//  	if( Debug() > 2 ) cout <<"Waiting   datapt at GPS:"
//  			       <<setprecision(15)<<bintime.totalS()<<"\t"<<data
//  			       <<endl;
//  	return false;
//  	//--------- Case 2: Tired of waiting-- end of event
//        } else if ( ch->DoneEvent(bintime, data) ) {
//  	if( Debug() > 2 ) cout <<"Finished  datapt at GPS:"
//  			       <<setprecision(15)<<bintime.totalS()<<"\t"<<data
//  			       <<endl;
//  	return true;
//  	//--------- Case 3: Not in event in the first place
//        } else return false;
//      }
//    }

//  //output glitchdata data
//  void suspensionMon::OutputEvent(chInterface* ch) 
//  {
//    if ( Debug() > 1) cout << "Outputting Event... channel "
//  			 << ch->fName       << " fEventMax= "
//  			 << setprecision(6) << ch->fEventMax   <<endl;
//    // include the next couple lines if you wish to put dead space between
//    // the actual event and when the data is good.
//    // ch->fStartTime -= (Interval)ch->fDeadTime;
//    // ch->fEndTime   += (Interval)ch->fDeadTime;
//    //=====================  Add event to histograms
//    double duration    = ch->fEndTime - ch->fStartTime;
//    double snglBinSize = ( ch->fPoles.size() + ch->fZeroes.size() +.5 ) 
//                           / (2 * ch->fSampleFreq) ;
//    if ( !(ch->fDeadTime) || (duration > snglBinSize) ) {
//      ch->fHist.Fill( abs(ch->fEventMax) );
//      ch->fHistAll.Fill( abs(ch->fEventMax) );
//      ch->fTimeHist.Fill( abs(ch->fEventMax), duration );
//      ch->fTimeHistAll.Fill( abs(ch->fEventMax), duration );
//    } else ch->fShortHist.Fill( abs(ch->fEventMax) );
//    //=====================  Add event to data file
//    if ( (fTriggerON & 1) && ch->fDeadTime ) {
//      //-----------  Initialize data file if it's not already
//      if ( !fDataInit ) {
//        // append initial UTC date to the filename & prepend appropriate path
//        string fDataName = fDataPath;
//        char *outSuffix= new char[12];
//        fDataName += (string) TimeStr(fInitTime,outSuffix,".%y.%m.%d");
//        delete[] outSuffix;
//        if (fDataName[0] != '/' && fDataName[0] != '.') {
//  	const char* datadir = getenv("DMTOUTPUT");
//  	if (datadir) fDataName = string(datadir) + "/" + fDataName;
//        }
//        fDataFile.open(fDataName.c_str(),ios::out|ios::app);
//        if (!fDataFile.is_open()){
//  	cerr<<"Data File Error: "<<fDataName<<endl;
//  	finish();
//  	return;
//        } 
//        fDataFile << "### Trigger Statistics:" << endl
//  		<< "### Event Start | Channel | Event Start | Duration  | "
//  		<< "Max Glitch Size | RMS during | Trigger"<<endl
//  		<< "###    (UTC)    |   Name  |    (GPS)    | (seconds) | "
//  		<< "  (in counts)   |   Glitch   | Comment"<<endl;
//        fDataInit = true;
//      } //  if ( !(fDataInit) )
  
//      //----------- output event to data file
//      char str[40] = "";
//      TimeStr(ch->fStartTime, str, "%y.%m.%d %H:%N:%S ");
//      fDataFile << str << ch->fName<<" "
//  	      << setw(17)<<setprecision(16)<<setfill('0')
//  	      <<double(ch->fStartTime.totalS())<<" "
//  	      <<setprecision(15)<< duration <<" "
//  	      <<setprecision(6) <<ch->fEventMax<<" "
//  	      <<setprecision(6) <<ch->fEventRMS<<" "
//  	      <<ch->fTrigComment
//  	      <<endl;
//    } //  if ( fTriggerON & 1 )
  
//    //=====================  Send event to Trigger Manager
//    if ( (fTriggerON & 2) && ch->fDeadTime ) {
//      string subID = ch->fName;
//      string Ifo   = ch->fName.substr(0,2);
//      trig::TrigRslt trigData("suspensionMon",subID.c_str());
//      trigData.setTime(        ch->fStartTime);
//      trigData.setDuration(    duration );
//      trigData.setIfos(        Ifo      );
//      trigData.setIntensity(   ch->fEventMax);
//      trigData.setSignificance(ch->fEventRMS);
//      trigData.setPriority(    trig::p_warn);
//      trigData.setDisposition( trig::d_metaDB);
//      if ( ch->fTrigComment.size() )
//        trigData.setData( ch->fTrigComment.c_str(), ch->fTrigComment.size() );
//      int trigerr = sendTrigger(trigData);
//      if ( trigerr && fLogFile.is_open() )
//        fLogFile<<"Error Sending Trigger: "<<trigerr<<" "<<ch->fEndTime<<endl;
//    } // if ( fTriggerON & 2 )
//    return;
//  }


// output log file 
void suspensionMon::OutputLog(bool check) 
{
  //=======================  Initialize log file if none exists
  if (!fLogInit) {
    // append initial UTC date to the filename & prepend appropriate path
    string fLogName = fLogPath;
    char *outSuffix= new char[12];
    fLogName += (string) TimeStr(fInitTime,outSuffix,".%y.%m.%d");
    delete[] outSuffix;
    if (fLogName[0] != '/' && fLogName[0] != '.') {
      const char* htmldir = getenv("DMTHTMLOUT");
      if (htmldir) fLogName = string(htmldir) + "/" + fLogName;
    }
    fLogFile.open(fLogName.c_str(),ios::out|ios::app);
    if (!fLogFile.is_open()){
      cerr<<"Log File Error: "<<fLogName<<endl;
      finish();
      return;
    }
   
  //-----------  Output configuration
    fLogFile << "#====================================" << endl
	     << "# file path to the text output data file" << endl
	     << "Data_File_Prefix : " << fDataPath << endl << endl
	     << "# file path to the log file" << endl
	     << "Log_File_Prefix  : " << fLogPath << endl << endl
	     << "# length of data to process in seconds (0 for infinity)"<<endl
	     << "Total_Runtime    : " << fEndRuntime << endl << endl
	     << "# of bins which composes each histogram" << endl
	     << "Number_Bins      : " << fBinNumber << endl << endl
	     << "# overall allows/disallows triggers to be sent"<<endl
	     << "Trigger_ON/OFF   : " << fTriggerON << endl << endl;
//      for ( CHiter i = fChannels.begin(); i != fChannels.end(); ++i ) {
//        fLogFile<<"Channel "<<i->getName()<<' '      <<i->fDeadTime<<' '
//  	      <<i->fUseOSC<<' '    	       <<i->fRMS<<' '
//  	      <<i->fThreshold<<' ';
//        fLogFile<<i->DumpPoles(fLogFile)<<" ";
//        fLogFile<<i->DumpZeroes(fLogFile)<<" ";
//        fLogFile<<i->fTrigComment<<endl;
//      }
//    //-----------  output starting time
//      if ( fLogStartTime == Time(0) ) { // output suspensionMon start time
//        fLogStartTime = fCurrentTime;
//        fLogFile << "###===================================="      << endl
//  	       << "### Monitor Start = " << fLogStartTime.getS() << endl
//  	       << "###------------------------------------"      << endl;
//    //-----------  set histogram time stamps
//        for ( CHiter ch = fChannels.begin(); ch != fChannels.end(); ch++ ) {
//  	ch->fHist.SetTime(fCurrentTime);
//  	ch->fHistAll.SetTime(fCurrentTime);
//  	ch->fTimeHist.SetTime(fCurrentTime);
//  	ch->fTimeHistAll.SetTime(fCurrentTime);
//  	ch->fShortHist.SetTime(fCurrentTime);
//        }
//      } // if ( !fLogStartTime.getS() )
//      fLogCount = 0;
//      fLogInit = true;
  } // if (!fLogInit)
//    //=====================  update log file every fLogInterval or at end of run
//    if ( !check || 
//         (fLogInterval && (fCurrentTime > fLogStartTime + fLogInterval)) ) {
//      fLogFile << "### Log_Interval: " << fLogCount
//  	     << "\tGPS_start: " << fLogStartTime.getS()
//  	     << "\tInterval_Duration: " << double(fCurrentTime - fLogStartTime)
//  	     <<endl
//  	     << "### Channel Statistics" << endl
//  	     << "### Channel | Filtered | Threshold | # Triggers  | # Triggers"
//  	     << " | Current  |  Dead Time  | Dead Time | Filtered | # Single-"
//  	     << endl
//  	     << "###  Name   |   RMS    |           | in Interval |    Total  "
//  	     << " | Run Time | in Interval |   Total   | Kurtosis | Bin "
//  	     << "Trigs" << endl;
//      // output channel statistics
//      Histogram1::stat_t mHistStats[4];
//      for ( CHiter ch = fChannels.begin(); ch != fChannels.end(); ch++) {
//        //=======  Print the total events in each histogram
//        fLogFile <<"#"<<fLogCount<<" "                    <<ch->fName<<"\t"
//  	       <<setprecision(6)<<ch->fRMS<<"\t" <<"Totals"<<"\t";
//        ch->fHist.GetStats(mHistStats); // 0th element is sum of events
//        fLogFile <<mHistStats[0]<<"\t";
//        ch->fHistAll.GetStats(mHistStats); // 0th element is sum of events
//        fLogFile <<mHistStats[0]<<"\t"                 <<fCount<<"\t";
//        ch->fTimeHist.GetStats(mHistStats); // 0th element is sum of events
//        fLogFile <<mHistStats[0]<<"\t";
//        ch->fTimeHistAll.GetStats(mHistStats); // 0th element is sum of events
//        fLogFile <<mHistStats[0]<<"\t"                 <<ch->fKurt<<"\t";
//        ch->fShortHist.GetStats(mHistStats); // 0th element is sum of events
//        fLogFile <<mHistStats[0]<<"\t"                 <<endl;
      
//        //=======  Print the event information for each threshold level
//        for (int i=fBinNumber + 1; i > 0 ; i--) //N+1 bins range from [1...(N+1)]
//  	fLogFile << "#"<<fLogCount<<" "
//  		 << ch->fName<<"\t"             
//  		 << setprecision(6)<<ch->fRMS<<"\t"
//  		 << setprecision(6)<<ch->fHist.GetBinLowEdge(i)<<"\t"
//  		 << ch->fHist[i]<<"\t"
//  		 << ch->fHistAll[i]<<"\t"
//  		 << fCount<<"\t"
//        		 << ch->fTimeHist[i]<<"\t"
//        		 << ch->fTimeHistAll[i]<<"\t"
//  		 << setprecision(6)<<ch->fKurt<<"\t"
//  		 << ch->fShortHist[i]<< endl;
//        ch->fStatCount = 0; // This resets the statistics
//        // clear contents and update histogram time stamp (fHist only)
//        ch->ClearHistogram();
//        ch->fHist.SetTime(fChannels.begin()->fTSnew->getEndTime());
//        ch->fTimeHist.SetTime(fChannels.begin()->fTSnew->getEndTime());
//        ch->fShortHist.SetTime(fChannels.begin()->fTSnew->getEndTime());
//      }
//      fLogFile <<"###====================================" << endl;
//      fLogStartTime = fCurrentTime;
//      fLogCount++;
//    } // if ( !check || fCurrentTime > fLogStartTime + fLogInterval )
//    return;  
}





void suspensionMon::Reset() {
  fEndRuntime   = 0;
  fCount        = 0;
  fLogStartTime = Time(0);
  fLogInterval  = 0;
  fCurrentTime  = Time(0);
  fLogPath      = "";
  fDataPath     = "";
  fTriggerON    = 0;
}

// Checks that next argument isn't an option
bool suspensionMon::chkNextArg(int i, const char* argv[], const int argc) {
  if (++i < argc) {
    std::string args(argv[i]);
    if (args[0] != '-') return true;
  } // Note: Doesn't check next arg for number value
  return false;
}

// Returns the initial string common to both parameter strings
string suspensionMon::getCommonString(const string& s1, const string& s2) {
  string common;
  for (unsigned int i=0; (i<s1.size() && i<s2.size()); i++) {
    if (s1.at(i) == s2.at(i)) common.append(1,s1.at(i));
    else break;
  }
  return common;
}

// Prints out a usage statement
int suspensionMon::Usage(const char* progName) {
  cerr << "Usage: "<< progName<<" [-conf <file>] [-osc <file>] "
       << "[-infile <frame_file>] [+toc | -toc] [-h | --help]" 
       << endl;
  return 1;
}

// Prints out a Help statement (not helpful)
int suspensionMon::Help(void) {
  cerr <<"suspensionMon looks for glitches with absolute thresholds (in counts)"
       <<"\nOptions include:\n"
       <<"  -conf   <file>       -- The configuration file to use as input\n"
       <<"  -osc    <file>       -- An OSC configuration file\n"
       <<"  -infile <frame_file> -- Used when running offline.  Frame files\n"
       <<"      can include a wildcard character, which must be escaped, as\n"
       <<"      in:   '-infile <frame_path>/H-R-\\*.gwf'\n"
       <<"  +toc or -toc         -- access frames using TOC (faster) or not\n"
       <<"  -h or --help         -- Generates this help text and exits"<<endl;
  return 1;
}

void suspensionMon::Attention() {
  MonServer::Attention();
}





