/* -*- mode: c++; c-basic-offset: 3; -*- */
#ifndef DQ_MODULE_HH
#define DQ_MODULE_HH 1

#include "MultiStream.hh"
#include "DQ_Bit.hh"
#include "frame_name.hh"
#include "FrWriter.hh"
#include "TSeries.hh"
#include <vector>
#include <string>
#include <iosfwd>

/**  The %DQ_Module class implements the %DQ_Module monitor. This montor calls 
  *  a boolean-values c++ function of one or more time series and uses the 
  *  result value to set one or more bit-mask channels. The monitor loads a 
  */
class DQ_Module : public MultiStream {
public:
   DQ_Module(int argc, const char* argv[]);
   ~DQ_Module(void);
   void book_channels(void);
   void init_all(void);
   void config(const std::string& cfg_file);
   void ProcessData(void);
   void put_config(std::ostream& out) const;
   void set_flag(DQ_bit* dq_def, const Time& t0, Interval dt);
   void write_frame(const Time& t0, Interval dT);
 private:
   double stride;
   double flag_step;
   bool   parity_bit;
   bool   invert;
   frame_name frame_path;
   std::string compression;
   std::string config_file;
   std::string config_version;
   uint32_t    config_crc32;
   std::vector<std::string> copy_channels;
   std::vector<std::string> copy_history;
   std::vector<DQ_bit*> flag_vect;
   FrWriter fr_writer;
   Time     output_start;
   Time     current;
   
   //-----------------------------------  define the flag map data type
   typedef std::map<std::string, TSeries> flag_map_type;
   typedef flag_map_type::iterator flag_map_iter;
   typedef flag_map_type::const_iterator const_flag_map_iter;
   flag_map_type flag_map;
   size_t   frames_out;
};
#endif
