/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "DQ_Bit.hh"
#include <stdexcept>

using namespace std;

//======================================  Plugin class constructor
DQ_bit::DQ_bit(void) {
}

//======================================  Plugin class constructor
DQ_bit::~DQ_bit(void) {
}

//======================================  Plugin class constructor
void 
DQ_bit::init(void) {
   ;
}

void 
DQ_bit::bit_channel(const std::string& chan) {
   _flag_channel = chan;
}

void 
DQ_bit::bit_number(int bit) {
   _flag_bit = bit;
}

void
DQ_bit::channel_list(const chanlist_type& chans) {
   _chan_list = chans;
}

//======================================  Plugin class-name
void
DQ_bit::dq_class(const std::string& dqclass) {
   _dq_class = dqclass;
}

void
DQ_bit::dq_name(const std::string& dqname) {
   _name = dqname;
}

//======================================  Plugin class constructor
double 
DQ_bit::numeric_param(const std::string& name) const {
   const_num_par_iter p = _num_par.find(name);
   if (p == _num_par.end()) {
      throw runtime_error(string("DQ_Bit: Parameter ") + name + " not defined");
   }
   return p->second;
}

//======================================  Set a string parameter
void 
DQ_bit::numeric_param(const std::string& name, double val) {
   if (_num_par.find(name) == _num_par.end()) {
      _num_par.insert(num_par_type::value_type(name, val));
   } else {
      _num_par[name] = val;
   }
}

//======================================  dump the configurationinformation.
void 
DQ_bit::put_config(ostream& out) const {
   out << "flag: " << dq_name() << endl;
   out << "   Plug-in:           " << dq_class() << endl;
   out << "   Channel:           " << bit_channel()   << endl;
   out << "   Bit number:        " << bit_number() << endl;
   out << "   Input data:        ";
   for (size_t i=0; i<_chan_list.size(); i++) {
      if (i) out << "                      ";
      out << _chan_list[i] << endl;
   }
   if (_chan_list.empty()) out << endl;
   out << "   String parameters: ";  
   for (const_str_par_iter i=_str_par.begin(); i != _str_par.end(); i++) {
      if (i != _str_par.begin()) out << "                      ";
      out << i->first << " = \"" << i->second <<"\"" << endl;
   }
   if (_str_par.empty()) out << endl;
   out << "   Numeric parameters: ";  
   for (const_num_par_iter i=_num_par.begin(); i != _num_par.end(); i++) {
      if (i != _num_par.begin()) out << "                      ";
      out << i->first << " = " << i->second << endl;
   }
   if (_num_par.empty()) out << endl;
}

//======================================  Fetch a string parameter
const std::string&
DQ_bit::string_param(const std::string& name) const {
   const_str_par_iter p = _str_par.find(name);
   if (p == _str_par.end()) {
      throw runtime_error(string("DQ_Bit: Parameter ") + name + " not defined");
   }
   return p->second;
}

//======================================  Set a string parameter
void 
DQ_bit::string_param(const std::string& name, const std::string& val) {
   if (_str_par.find(name) == _str_par.end()) {
      _str_par.insert(str_par_type::value_type(name, val));
   } else {
      _str_par[name] = val;
   }
}
