#ifndef BandMonitor_HH
#define BandMonitor_HH

#include "DatEnv.hh"
#include "MonServer.hh"
#include "TrigRslt.hh"
#include "TrigClient.hh"
#include "Segment.hh"
#include <sys/types.h>
#include <iosfwd>
#include <vector>
#include <iostream>

class Trend;
class Rms_output;
class RmsConfig;
class Chan_filtset;

using namespace std;

//
//    Data Monitor template class.
//    Class DatTemplate inherits member functions both from
//    Class DatEnv and from Class MonServer
//

struct flags {
  int active;
  Time time;
  float value;	
};

class BandMonitor : public DatEnv, MonServer, TrigClient
{
public:
  int MaxFrame;               //  Number of frames I should process

  BandMonitor(int argc, const char *argv[]);  // Constructor
  ~BandMonitor();                             // Destructor
  void ProcessData(void);
  void Attention(void);
  void DumpHelp(void);
  void sendSeg(trig::Segment s);
  void htmloutput();
private:
  typedef std::vector<std::string> str_vect;
  typedef std::vector<TSeries>     tser_vect;

  TrigClient mTC;

  int read_count;

  // trend add-on
  Time tStart;
  Time tCur;
  bool make_trends;
  bool make_trend_index;
  str_vect  trend_channel_list;
  Trend* pblrmsTrend;
  std::string trend_name;
  // end trend add-on
  // KSG 8/25/05 add-ons to accomadate new output channel names
  std::string trend_name_new;
  // end add-on by KSG for new names
  // addon flag to allow for no text file writing
  bool make_text_file;
  // end of addon for no text file writing
  Interval monDt;

  // original private data members for band limited rms monitor
  std::vector<TSeries*> ts;
  RmsConfig* rmspar;
  int are_filters_initialized;
  int count_seconds;
  int* srate;
  int number_of_filter_outputs;
  Chan_filtset* filters;
  Chan_filtset* filtersgood;
  Rms_output* file_output;
  int segment_counter;
  int time_lost_int_total;
  std::vector<float> data_store;
  int column_tally;
  int column_count;
  int data_error;
  long int total_seconds_to_run;
  long int second_counter;
  bool first_reading_done;
  Time tnow;
  Interval time_per_rms_reading;
  char mon_server_name[ 100 ];
  str_vect monitor_names;
  int max_monitor_name_length;
  char* mon_name_buf;
  int monitor_length;
  tser_vect monitor_tseries;
  tser_vect monitor48h_tseries;

  //Flag Status used in HTMLOUTPUT
  flags flag_status[100];

  FILE* uout;

  //    Last tim for gap checking
  Time mLast_t0;

};

#endif     //  BandMonitor_HH
