//
// PlaneMon
// Author: Evan Goetz (egoetz@umich.edu)
// 31 October 2005
//
////////////////////////////////////////////////

#ifndef PlaneMon_HH
#define PlaneMon_HH

#include "DatEnv.hh"
#include "MonServer.hh"
#include "Time.hh"
#include "TrigClient.hh"
#include "AlarmClient.hh"
#include <string>

//=====================================  Root classes
class TCanvas;
class TH1F;
class TF1;
class TPaveText;

class Pipe;
class PlaneMonConfig;
class TSeries;

class PlaneMon : public DatEnv, MonServer, TrigClient {
public:
    /** Construct a PlaneMon object.
      * @memo Constructor
      */
    PlaneMon(int argc, const char *argv[]);  
    
    /** Destroy a PlaneMon object.
      * @memo Destructor
      */
    ~PlaneMon(void);
    
    /** Process one data stride.
      * @memo Process data statement.
      */
    void ProcessData(void);
    
    /** Create summary html page.
      * @memo current monitor status saved to html page
      */
    virtual void Summary(const Time& t);

    /** Create current plots html page.
      * @memo current channel plots saved to html page
      */
    virtual void CurrentPlots(const Time& t);

    /** Archive events based on verbosity level.
      * @memo saved archive event to folder linked by
      *    achived events webpage
      */
    virtual void archiveEvent(const Time& t, const Time& tup);

    TH1F* bumpPlot(int i, const std::string& name) const;
    
    /** Attention interrupt.
      * @memo Handle message signal.
      */
    void Attention(void);

    /** Generate segments
      * @memo Save segment to database
      */
    void genSegment(TrigClient& tc);
    
private:
    char configFilename[100];
    
    void fitcurve(const int& i, const Time& t);

    AlarmClient mAlarm;		// alarm
    AlarmData	planeAlarm;	// plane alarm
    AlarmData	elevatedAlarm;	// elevated alarm
    
    std::string	mChannel;       // Channel name
    std::string	mFoldername;	// name of folder to be used
    std::string	mEpoch;         // time period of event
    std::string	mGpsNow;
    std::string	mGpsEvent;
    std::string	dirloc;		// directory where everything is to be saved
    std::string	mLoc;		// observatory location--H or L in arguments
 
    bool	syntax;         // syntax flag
    bool	mElevAlarmOn;	// elevated alarm currently on
    bool	mPlAlarmOn;	// plane alarm currently on
    bool	mArchiveEvent;	// airplane candidate
    bool	mMakejpg;       // Flag to create jpeg images
    bool	mMakegif;       // create gif images at time of eps creation
    bool	mCandidate;     // candidate event flag
    bool	mDebug;
    bool*	mChanTrgd;	// channel triggered
    bool*	mTrigOn;	// trigger on
    bool*	mFitted;	// plot is fitted
    
    TSeries*	mlastTS;	// previous T series
    
    Time	mlastevent;	// most recent event time
    Time	mElevAlarmSetTime;	// start of elevated alarm
    Time	mPlAlarmSetTime;	// start of plane alarm
    Time	mArchiveTime;	// time the archiving is started
    Time	mArchiveFinish; // time the archiving should be done, 2 min past recent event
    Time	mTimeBuffer;    // time between events
    Time*	mfirstt0;	// first time a bump occurs in type Time
    Time*	mTrigSetTime;	// start of trigger for each channel
    
    int		mVerbosity;	// verbosity level
    int		mCounter;	// count program executions
    int		mArrayPointer;	// counter that points to the array location
    int		mTrgdChans;	// number of channels triggered
    int		mExtraBumps;    // number of bumps after an event
    int*	mBumpCount;     // bump counter
    int*	mPointer;	// counter that points to location in TF plots
    
    double	mT;			// current time
    double*	mfirsttime;		// first time a bump is recorded
    double*	mlasttime;		// last time a bump was recorded
    double*	mCenterFreq;		// bump weighted central frequency
    double*	mCenterFreqAmp;		// bump amplitude
    double*	mCenterFreqStdDev;	// bump standard deviation
    double*	mInvCenterFreqStdDev;	// bump inverse frequency std. dev.
    double***	mTotalArray;		// spectrogram over past 2 min
    double***	mTotalShape;		// shape of spectrogram for pas 2 min.
    double**	xarray;			// time of bumps
    double**	yarray;			// frequency of bumps
    double**	stddevs;		// standard devaition of bumps
    double**	invstddevs;		// inverse frequency std. dev.
    double	mChiSq;			// chi squared
    
    TCanvas*	canvas;			// Plots canvas
    TH1F**	plots;			// Bumps plots
    TH1F**	fittedPlots;		// fitted plots
    TF1**	planeFits;		// Fit plots
    TF1*        polfit;
    TF1*        fit;
    TPaveText**	curveInfos;		// plane parameters info box
    
    PlaneMonConfig*	parameters;	// PlaneMon parameters
    
    TrigClient  mTrigC;                 // Trigger client   

};

#endif     //  PLANEMON_HH
