#ifndef PHOTONCAL_HH
#define PHOTONCAL_HH

#include "DatEnv.hh"
#include "MonServer.hh"
//#include "FSeries.hh"
#include "FSpectrum.hh"
#include "TSeries.hh"
#include "Trend.hh"
#include "AlarmClient.hh"
#include "TrigPar.hh"
#include "PSD.hh"
#include "DecimateBy2.hh"
//#include "FDCalibrate.hh"
#include "Blackman.hh"


class ostream;

using namespace std;

//
//    PHOTONCAL class.
//
class PhotonCal : public DatEnv, MonServer {
public:
    int MaxFrame;                             // Number of frames to process
    PhotonCal(int argc, const char *argv[]);  // Constructor
    ~PhotonCal();                             // Destructor
    void ProcessData(void);
    void Attention(void);
    bool ReadConfig(void);
    void Reset(void);
    void logError(string s);
    void logInfo(string s);
private:
    Trend mTrendMinute;
    AlarmClient mAlarm;

    //  Object calculates the power-spectral density
    //  (stored in an FSpectrum object) of the
    //  TSeries data fed to it.  See PSD.hh for 
    //  further explanation.
    PSD *psd;  

    //  Pointer to Blackman window.
    Blackman *black; 

    DecimateBy2 *gwdecimator;
    DecimateBy2 *xdecimator;
    DecimateBy2 *ydecimator;

    //FDCalibrate *calibrator;

    // Holds the PSD of the data.  It is filled by PSD::generate().
    FSpectrum fdata;

    TrigPar   mDict;
    std::string    mCFile;
    int DEBUG;

};

#endif     //  PHOTONCAL_HH
