#ifndef WPIPE_TYPES_HH
#define WPIPE_TYPES_HH

#include "TSeries.hh"
#include "fSeries/DFT.hh"
#include <string>
#include <vector>

// If defined, DFTs are unnormalized immediately after they are calculated.
// The results should remain the same, although a few normalization operations
// are repeated.
// #define UNNORMALIZED_DFTS 1

//  If defined the matlab bugs are left in.
// #define OMEGA_MATLAB_BUGS 1

//  Don't attempt to compile coherent search code (not implemented).
#define NO_TARGETED 1
#define NO_COHERENT 1
#define NO_COINCIDENCE 1
#define NO_FOLLOWUP 1

namespace wpipe {

  typedef std::vector<bool>            bool_vect;
  typedef std::vector<double>          dble_vect;
  typedef dble_vect::iterator          dble_iter;
  typedef std::vector<containers::DFT> dft_vect;
  typedef std::vector<TSeries>         tser_vect;
  typedef std::vector<std::string>     str_vect;
  typedef str_vect::const_iterator     const_strv_iter;

}
#endif // !defined(WPIPE_TYPES_HH)
