/***************************************************************************
    File        : Multirate.cpp
    Description : Implement class Multirate
 ---------------------------------------------------------------------------
    Begin       : Tue Aug 30 2005
    Author(s)   : Roberto Grosso
 ***************************************************************************/


#include "Multirate.h"
  

bool
gwd::Multirate::Multirate::Decimate(const int factor,Vector& h,Vector& in,Vector& out)
{
  // nothing to be done
  if (factor == 0)
  {
    Singleton* single = gwd::Singleton::exemplar();
    single->AppendMessage("gwd::Multirate::Decimate(): decimation factor = 0");
    return false;
  }
    
  // low-pass filter
  FIRFilter fir;
  Vector lpsignal;
  if (!fir.Filter(in,h,lpsignal))
  {
    Singleton* single = gwd::Singleton::exemplar();
    single->AppendMessage("gwd::Multirate::Decimate(): can't dowsample with FIR filter");
    return false;
  }

  // sizes
  const int oSize = (int) lpsignal.size() / factor;
  out.resize(oSize);
  for (int ii = 0; ii < oSize; ii++) out[ii] = lpsignal[factor*ii];

  return true;
} // Decimate()

