/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef ATTRLIST_HH
#define ATTRLIST_HH

#include <map>
#include <string>

//  This is the definition of an attribute list.
namespace xsil {
    /**  \ingroup IO_xsil
      */

    ///  Attribute list for xsil objects.
    typedef std::map<std::string, std::string> attr_list;

    ///  Iterator type for attribute list.
    typedef attr_list::iterator attr_iter;

    /// Constant iterator data type for attribute list
    typedef attr_list::const_iterator const_attr_iter;
}

#endif  // ATTRLIST_HH
