#include <strings.h>
#include <time.h>
#include <iostream>
#include "xml/XsilFSpectrum.hh"		// Associated header file
//=============  gds header files
#include "DVector.hh"		// DVector data container (shouldn't be nec.)


   using namespace std;
namespace xml {


/*-----------------------------------------------------------------------*/
/*   default xsilFSpectrum write function                                */
/*-----------------------------------------------------------------------*/
   std::ostream& 
   xsilFSpectrum::write (std::ostream &os) const {
      if (fSubtype == 0) 
         return writeFSeries(os);
      else if (fSubtype == 1) 
         return writeFSpectrum(os);
      else 
         return os;  //Writes nothing
   }


/*-----------------------------------------------------------------------*/
/*   xsilFSpectrum write function for FSeries                            */
/*-----------------------------------------------------------------------*/
   std::ostream& 
   xsilFSpectrum::writeFSeries (std::ostream &os) const {
   //:NOTE: I don't even try to output complex FSeries, as dtt can't currently
   //:NOTE:   read them.
    //=============================  Deal with omplex data as an FSpectrum
      if (fData0->refDVect()->getType() == DVector::t_complex ||
         fData0->refDVect()->getType() == DVector::t_dcomplex) {
         FSpectrum mFSpec(*fData0);
         xsilFSpectrum xfs(&mFSpec);
         return xfs.write(os);
      //=============================  Deal with float data normally
      } 
      else {
      //==========  Too many calls require the NStep. Get it once here
         unsigned long Npts = fData0->getNStep() + 1;
         if (!fData0->getName()) {
            os << xsilDataBegin("DMT FSeries","Spectrum",fLevel)<<endl;
            os << xsilParameter<string>("ChannelA","channel","DMT FSeries",1,
                                 fLevel+1)<<endl;
         } 
         else {
            os << xsilDataBegin(fData0->getName(), "Spectrum",fLevel)<<endl;
            os << xsilParameter<string>("ChannelA","channel",fData0->getName(), 1,
                                 fLevel+1)<<endl;
         }
      //==========  Parameters common to both ligolw & FSeries
      //----------  (Force all FSeries-- folded & full-- into one format)
      //----------  (Basically have to double intensity for double-sided)
         os << xsilParameter<double>("f0","Hz",fData0->getCenterFreq(), 1,
                              fLevel+1)<<endl;
         os << xsilParameter<double>("df","Hz",fData0->getFStep(), 1,
                              fLevel+1)<<endl;
         os << xsilTime("t0",fData0->getStartTime().getS(),
                       fData0->getStartTime().getN(), fLevel+1)<<endl;
         os << xsilParameter<double>("dt","s",double(fData0->getDt() ), 1,
                              fLevel+1)<<endl;
      //:NOTE: I don't even try to output double-sided FSeries, since I can't trust
      //:NOTE:   its format.
	 if (fData0->isSingleSided()) 
	     os << xsilParameter<int>("N",Npts, 1, fLevel+1)<<endl;
	 else {
	   cerr<<"Can't export double-sided FSeries: "<<fData0<<endl;
	   return os;
	 }
      //:NOTE: Should I have an argument for # of averages here?
      //==========  Parameters found only in FSeries
         os << xsilTime("EndTime",fData0->getEndTime().getS(),
                       fData0->getEndTime().getN(), fLevel+1)<<endl;
         os << xsilParameter<double>("MaximumFrequency",fData0->getHighFreq(),1, 
                              fLevel+1)<<endl;
      //==========  Parameters found only in ligolw
      // Bandwidth Resolution (full-width, 1/2 maximum of main lobe of Fourier
      //  transform of windowing function) is assumed to be df for FSeries.
         os << xsilParameter<double>("BW","Hz",fData0->getFStep(), 1, 
                              fLevel+1)<<endl;
      // Windowing function is assumed to be 0 for FSeries.
         os << xsilParameter<int>("Window",int(0), 1,fLevel+1)<<endl;
      // Number of spectra (always 1)
         os << xsilParameter<int>("Subtype",int(0), 1, fLevel+1)<<endl;
         os << xsilParameter<int>("M",int(1),1,fLevel+1)<<endl;
         if (fData0->isSingleSided()) {
	   float *data = new float[Npts];
	   fData0->getData(Npts,data);
	   os << xsilDataEnd<float>(Npts,data, fLevel);
	   delete[] data;
	 }
         return os;
      }
   }

/*-----------------------------------------------------------------------*/
/*   xsilFSpectrum write function for FSpectrum                          */
/*-----------------------------------------------------------------------*/
   std::ostream& 
   xsilFSpectrum::writeFSpectrum (std::ostream &os) const {
    //==========  Too many calls require the number of points. Get it once here
      int Npts = fData1->getNStep() + 1;
      if (!fData1->getName()) {
         os << xsilDataBegin("DMT FSpectrum","Spectrum",fLevel)<<endl;
         os << xsilParameter<string>("ChannelA","channel","DMT FSeries",1,
                              fLevel+1)<<endl;
      } 
      else {
         os << xsilDataBegin("DMT FSpectrum", "Spectrum",fLevel)<<endl;
         os << xsilParameter<string>("ChannelA","channel",fData1->getName(), 1,
                              fLevel+1)<<endl;
      }
    //==========  Parameters common to both ligolw & FSpectrum
      os << xsilParameter<double>("f0","Hz",fData1->getLowFreq(), 1,
                           fLevel+1)<<endl;
      os << xsilParameter<double>("df","Hz",fData1->getFStep(), 1,
                           fLevel+1)<<endl;
      os << xsilTime("t0",fData1->getStartTime().getS(),
                    fData1->getStartTime().getN(), fLevel+1)<<endl;
      os << xsilParameter<double>("dt","s",double(fData1->getEndTime() - 
                                             fData1->getStartTime() ), 1,
                           fLevel+1)<<endl;
      os << xsilParameter<int>("N",Npts, 1, fLevel+1)<<endl;
      os << xsilParameter<int>("Averages",fData1->getCount(), 1,
                           fLevel+1)<<endl;
    //==========  Parameters found only in FSpectrum
      os << xsilTime("EndTime",fData1->getEndTime().getS(),
                    fData1->getEndTime().getN(), fLevel+1)<<endl;
      os << xsilParameter<double>("MaximumFrequency",fData1->getHighFreq(),1, 
                           fLevel+1)<<endl;
    //==========  Parameters found only in ligolw
    // Bandwidth Resolution (full-width, 1/2 maximum of main lobe of Fourier
    //  transform of windowing function) is assumed to be 1.5df for FSpectrum
    //  (assumed to be a Hanning Window)
      os << xsilParameter<double>("BW","Hz", 1.0 * fData1->getFStep(), 1, 
                           fLevel+1)<<endl;
    // Windowing function is assumed to be Hanning
      os << xsilParameter<int>("Window",int(0), 1,fLevel+1)<<endl;
    // Number of spectra (always 1)
      os << xsilParameter<int>("M",int(1),1,fLevel+1)<<endl;
    //===================  Write Subtype, data array-- float data
      os << xsilParameter<int>("Subtype",int(1), 1, fLevel+1)<<endl;
      float *data = new float[Npts];
      fData1->getData(Npts,data);
    //=========  Convert DMT Power->Amplitude Spectrum; conform to dtt std
      for (int i=0;i<Npts;i++) data[i] = sqrt(data[i]);
      os << xsilDataEnd<float>(Npts,data, fLevel);
      delete[] data;
      return os;
   }


/*************************************************************************
 ** Xsil handler methods                                                **
 *************************************************************************/

/*-----------------------------------------------------------------------*/
/*   xsilHandlerFSpectrum                                                  */
/*                                                                       */
/*   Handles FSpectrum records                                             */
/*-----------------------------------------------------------------------*/
   xsilHandlerFSpectrum:: 
   xsilHandlerFSpectrum(vector<FSpectrum> *specs, vector<FSeries> *sers,
                     const attrlist *attr, bool ignore)
   : xsilHandler(ignore),fSpectrums(specs),fSeries(sers),fName(""),
   fSubtype(-1),fSec(0),fNsec(0),fDt(0),fF0(0),fDf(0),fAverages(0),fBW(0),
   fComplex(false),fData(0),fDim1(0),fDim2(0) {
   }

//__________________________________________________________________________
   xsilHandlerFSpectrum::~xsilHandlerFSpectrum() {
     //=================================  If we have single-column data...
      if (fDim1 && fSec && fDim2 <= 0) {
       //==========================  Float Data: standard methods
         if (!fComplex) {
         ////////////////  both FSeries and FSpectrum need time variable
            Time tm(fSec,fNsec);
         ////////////////  Case 0: FSeries object
            if ( fSubtype == 0 ) {
               if (!fSeries) cerr <<"Couldn't find FSeries vector."<<endl;
               else {
                  cout <<"Would have parsed FSeries if I had the guts."<<endl;
               }
            ////////////////  Case 1: FSpectrum object
            } 
            else if ( fSubtype == 1 ) {
               if (!fSpectrums) cerr <<"Couldn't find FSpectrum vector."<<endl;
               else {
                  for (int i=0;i<fDim1;i++) fData[i] *= fData[i];
                  FSpectrum fs(fF0, fDf, tm, fDt, (FSpectrum::size_type) fDim1, fData);
                  fs.setName(fName.c_str());
                  fs.setCount( (FSpectrum::size_type) fAverages);
               //:NOTE: Although DMT doesn't have an option for bandwidth, we have a place
               //:NOTE:  for it here.
               //  	     fs.setBW(fBW);
                  fSpectrums->push_back(fs);
               }
            ////////////////  Case (-1): Subtype hasn't been specified
            } 
            else cerr <<"Couldn't identify subtype for Spectrum object."<<endl;
         //==========================  Complex Data: handle differently (or not)
         } 
         else {
            cerr <<"Data is complex.  Can't parse this..."<<endl;
            cerr <<"Stats: Time="<<fSec<<","<<fNsec<<"\t Name="<<fName
               <<"\t Dim1="<<fDim1<<"\t Dim2="<<fDim2<<endl;
         }
      //=================================  Not single-column; can't parse this.
      } 
      else {
         cerr <<"Something's wrong with FSpectrum data-- can't send up..."<<endl;
      }
      delete [] fData;
      fData = 0;
   }

//__________________________________________________________________________
   bool xsilHandlerFSpectrum::HandleParameter(const std::string& name, 
                     const attrlist& attr, 
                     const int& p, int N) {
      if (strcasecmp (name.c_str(), "Subtype") == 0) {
         fSubtype = p;
         return true;
      } 
      else if (strcasecmp (name.c_str(), "Averages") == 0) {
         fAverages = p;
         return true;
      } 
      else if (strcasecmp (name.c_str(), "Window") == 0) 
         return true;
      else if (strcasecmp (name.c_str(), "N") == 0) 
         return true;
      else if (strcasecmp (name.c_str(), "M") == 0) 
         return true;
      else 
         return false;
   }

//__________________________________________________________________________
   bool xsilHandlerFSpectrum::HandleParameter(const std::string& name, 
                     const attrlist& attr, 
                     const double& p, int N) {
      if (strcasecmp (name.c_str(), "f0") == 0) {
         fF0 = p;
         return true;
      } 
      else if (strcasecmp (name.c_str(), "df") == 0) {
         fDf = p;
         return true;
      } 
      else if (strcasecmp (name.c_str(), "dt") == 0) {
         fDt = p;
         return true;
      } 
      else if (strcasecmp (name.c_str(), "BW") == 0) {
         fBW = p;
         return true;
      } 
      else if (strcasecmp (name.c_str(), "MaximumFrequency") == 0) {
         return true;
      } 
      else 
         return false;
   }

//__________________________________________________________________________
   bool xsilHandlerFSpectrum::HandleParameter(const std::string& name, 
                     const attrlist& attr, 
                     const std::string& p) {
      if (strcasecmp (name.c_str(), "ChannelA") == 0) {
         fName = p;
         return true;
      } 
      else 
         return false;
   }

//__________________________________________________________________________
   bool xsilHandlerFSpectrum::HandleTime 
   (const std::string& name, const attrlist& attr, 
   unsigned long sec, unsigned long nsec) {
      if (strcasecmp (name.c_str(), "t0") == 0) {
         fSec = sec;
         fNsec = nsec;
         return true;
      } 
      else if (strcasecmp (name.c_str(), "EndTime") == 0) 
         return true;
      else 
         return false;
   }

//__________________________________________________________________________
   bool xsilHandlerFSpectrum::HandleData (const std::string& name,float* x, 
                     int dim1, int dim2, int dim3,
                     int dim4) {
      if (fData) delete [] fData;
      fDim1 = dim1;
      fDim2 = dim2;
      fData = x;
      fComplex = false;
      return true; 
   }

//__________________________________________________________________________
   bool xsilHandlerFSpectrum::HandleData (const std::string& name,
                     std::complex<float>* x, int dim1, 
                     int dim2, int dim3, int dim4) {
      if (fData) delete [] fData;
      fDim1 = dim1;
      fDim2 = dim2;
      fData = (float*)x;
      fComplex = true;
      return true; 
   }


/*-----------------------------------------------------------------------*/
/*   xsilHandlerQueryFSpectrum                                             */
/*                                                                       */
/*   Handler query for option array                                      */
/*-----------------------------------------------------------------------*/
   xsilHandler* xsilHandlerQueryFSpectrum::GetHandler(const attrlist& attr) {
      attrlist::const_iterator ft = attr.find (xmlType);
      if ((ft != attr.end()) &&
         (strcasecmp (ft->second.c_str(), "Spectrum") == 0)) {
         return new (nothrow) 
            xsilHandlerFSpectrum(fSpectrum,fSeries,&attr,false);
      } 
      else 
         return 0;
   }


} // namespace xml
