//
//    Stand alone application to create a shared memory partition.
//
//    Syntax:
//       smcreate <name> [-nbuf <nbuf>] [-lbuf <lbuf>]
//
//       <name>    name of the partition to be created
//       <nbuf>    number of buffers 
//       <lbuf>    length of each buffer in bytes.
//
#include <stdlib.h>
#include <iostream>
#include "lsmp_prod.hh"
#include <string>

int 
main(int argc, const char ** argv) {
    std::string name;
    int nbuf = 4, lbuf = 2048;
    bool lock = false;
    //-------------------------------  Get the command line arguments
    bool argerr(false), ra(false);

    for (int i=1 ; i<argc ; i++) {
        std::string argi = argv[i];
        if (argi == "-nbuf") {
	    nbuf = strtol(argv[++i], 0, 0);
	} else if (argi == "-lbuf") {
	    lbuf = strtol(argv[++i], 0, 0);
	} else if (argi == "-lock") {
	    lock = true;
	} else if (argi == "+readall" || argi == "+ra") {
	    ra = true;
	} else if (i == 1 && (argi[0] != '-') && (argi[0] != '?')) {
	    name = argi;
	} else {
	    std::cerr << "smcreate: Invalid argument " << argi << std::endl;
	    argerr = true;
	}
    }
    //-------------------------------  Print an error message if appropriate.
    if (argerr || (argc < 2)) {
        std::cerr << "smcreate: Create a shared memory partition" << std::endl;
	std::cerr << "Syntax:" << std::endl;
	std::cerr << *argv << " <partition-name> [-nbuf <number-of buffers>]"
	     << " [-lbuf <buffer-length>] [+readall | +ra]" << std::endl;
	exit(1);
    }

    //-------------------------------  Do the dirty work. Make sure the 
    //                                 partition isn't deleted immediately 
    LSMP_PROD* part = new LSMP_PROD(name.c_str(), nbuf, lbuf);
    if (lock) part->lock(true);
    if (ra) part->bufmode(3);
    part->keep();
    delete part;
    exit(0);
}
