/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "lmsg/Buffer.hh"
#include "lmsg/TransInput.hh"
#include "Time.hh"
#include <string>

using namespace std;
using namespace lmsg;

static Grinder grub;

TransInput::TransInput(const Buffer& b) {
    mData   = b.getDataAddr();
    mIndex  = 0;
    mLength = b.getDataLength();
}

TransInput::TransInput(void) 
  : mData(0), mIndex(0), mLength(0)
{
}

template<>
lmsg::size_type 
TransInput::read(char x[], size_type N) {
    if ( !available(N) ) N = mLength-mIndex;
    memcpy(x, mData+mIndex, N);
    mIndex += N;
    return N;
}

template<>
lmsg::size_type 
TransInput::read(MsgAddr x[], size_type N) {
    MsgAddr::ipport_t ports[2];
    MsgAddr::ipaddr_t ipaddr;
    //size_type nB = sizeof(MsgAddr::ipaddr_t);
    //align(sizeof(MsgAddr::ipaddr_t));
    for (size_type i=0 ; i<N ; i++) {
        //if (read(reinterpret_cast<char*>(&ipaddr), nB) != nB) return i;
	if (!read(&ipaddr, 1)) return i;
	if (read(ports, 2) != 2) return i;
	x[i] = MsgAddr(ipaddr, ports[0], ports[1]);
    }
    return N;
}

template<>
lmsg::size_type 
TransInput::read(string x[], size_type N) {
    unsigned short Ls;
    for (size_type i=0 ; i<N ; i++) {
        if (!read(&Ls, 1)) return i;
	if ( !available(Ls) ) return i;
	x[i] = string(mData+mIndex, Ls);
	mIndex += Ls;
    }
    return N;
}

template<>
lmsg::size_type 
TransInput::read(Time x[], size_type N) {
    gps_export_type td[2];
    for (size_type i=0; i<N; ++i) {
	if (read(td, 2) != 2) return i;
	x[i] = Time(td[0], td[1]);
    }
    return N;
}

void
TransInput::align(size_type N) {
    size_type nByte = (-mIndex) & (N-1);
    mIndex += nByte;
}
