#include "lmsg/UDPSocket.hh"
#include "lmsg/SocketPool.hh"

lmsg::SocketPool defaultLMsgSocketPool;

lmsg::SocketPool::~SocketPool(void) {
    thread::semlock lockit (mMux);
    while (mClient.begin() != mClient.end()) {
        delete mClient.front();
	mClient.pop_front();
    }
}

lmsg::SocketPool::SocketPool(void) {
}

lmsg::Socket* 
lmsg::SocketPool::getSocket(requestType type, const MsgAddr* addr) {
    thread::semlock lockit (mMux);
    Socket* s;
    if (type == s_reusable && !mClient.empty()) {
        s = mClient.front();
	mClient.pop_front();
    } else {
        s = new UDPSocket(addr);
	if (!s->isOpen()) {
	    delete s;
	    s = 0;
	} else if (type == s_reusable) {
	    s->setPool(this);
	}
    }
    return s;
}

void 
lmsg::SocketPool::returnSocket(Socket* s) {
    thread::semlock lockit (mMux);
    if (s) mClient.push_back(s);
}
